/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.io;

import java.io.File;
import java.io.IOException;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/02
 */
public final class AwkVirtualFile {

	static final File STDIN  = new File("/dev/stdin");
	static final File DIALOG = new File("/dev/dialog");

	static final File STDOUT = new File("/dev/stdout");
	static final File STDERR = new File("/dev/stderr");
	static final File NULL   = new File("/dev/null");
	static final File MSGBOX = new File("/dev/msgbox");

	static final LineWriter NULLWRITER = new LineWriter() {

		public void print(String s) {
		}

		public void println(String s) {
		}

		public void printf(String format, Object... args) {
		}

		public void flush() {
		}

		public void close() throws IOException {
		}

	};

	/**
	 * 
	 * @param fname
	 * @param fs
	 * @return
	 */
	public static LineWriter out(String fname, AwkFiles fs) {
		File f = new File(fname);

		if(f.equals(STDOUT)) {
			return fs.getStdout();
		} else if(f.equals(STDERR)) {
			return fs.getStderr();
		} else if(f.equals(NULL)) {
			return NULLWRITER;
		} else {
			return null;
		}
	}

	/**
	 * 
	 * @param fname
	 * @param fs
	 * @return
	 */
	public static RecordReader in(String fname, AwkFiles fs) {
		File f = new File(fname);

		if(f.equals(STDIN)) {
			return fs.getStdin();
		} else {
			return null;
		}
	}

}
