/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

import net.morilib.awk.namespace.AwkNamespace;

public class RecordReader extends BufferedReader {

	private AwkNamespace ns;

	/**
	 * 
	 * @param in
	 * @param ns
	 */
	public RecordReader(Reader in, AwkNamespace ns) {
		super(in);
		this.ns = ns;
	}

	/**
	 * 
	 * @return
	 * @throws IOException
	 */
	public String readRecord() throws IOException {
		String rs = ns != null ? ns.getRS() : "\n", s, d = "";
		StringBuffer b = null;
		int c;

		if(rs.equals("")) {
			while((s = readLine()) != null && !s.equals("")) {
				if(b == null)  b = new StringBuffer();
				b.append(d).append(s);
				d = "\n";
			}
			return b != null ? b.toString() : null;
		} else if(rs.equals("\n")) {
			return readLine();
		} else {
			while((c = read()) >= 0) {
				if(c == rs.codePointAt(0)) {
					return b != null ? b.toString() : "";
				} else if(b == null) {
					b = new StringBuffer();
				}
				b.append((char)c);
			}
			return b != null ? b.toString() : null;
		}
	}

}
