/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.a;

import net.morilib.awk.namespace.AwkNamespace;

/**
 * パッケージaの関数を読み込みます。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class AwkArrayBuiltInLoader {

	/**
	 * 
	 * @param ns
	 */
	public static void load(AwkNamespace ns) {
		AwkNamespace ss = ns.subnamespace("a");

		ss.bindFunction("addall",      new ArrayAddall());
		ss.bindFunction("any",         new ArrayAny());
		ss.bindFunction("c",           new ArrayC());
		ss.bindFunction("clear",       new ArrayClear());
		ss.bindFunction("containkeys", new ArrayContainKeys());
		ss.bindFunction("copy",        new ArrayCopy());
		ss.bindFunction("equalkeys",   new ArrayEqualKeys());
		ss.bindFunction("equals",      new ArrayEquals());
		ss.bindFunction("every",       new ArrayEvery());
		ss.bindFunction("except",      new ArrayExcept());
		ss.bindFunction("intersect",   new ArrayIntersect());
		ss.bindFunction("iota",        new ArrayIota());
//		ss.bindFunction("makelist",    new ArrayMakelist());
		ss.bindFunction("member",      new ArrayMember());
		ss.bindFunction("removeall",   new ArrayRemoveall());
		ss.bindFunction("retainall",   new ArrayRetainall());
		ss.bindFunction("size",        new ArraySize());
		ss.bindFunction("union",       new ArrayUnion());
	}

}
