/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.io;

import java.io.IOException;

/**
 * awkiumで使用する仮想ファイルを管理します。<br />
 * awkiumには物理的なファイル名のほかに標準出力をあらわす
 * /dev/stdoutなどの仮想ファイル名があります。
 *
 * @author MORIGUCHI, Yuichiro 2013/04/02
 */
public final class AwkVirtualFile {

	static final String STDIN  = "/dev/stdin";
	static final String DIALOG = "/dev/dialog";

	static final String STDOUT = "/dev/stdout";
	static final String STDERR = "/dev/stderr";
	static final String NULL   = "/dev/null";
	static final String MSGBOX = "/dev/msgbox";

	static final LineWriter NULLWRITER = new LineWriter() {

		public void print(String s) {
		}

		public void println(String s) {
		}

		public void printf(String format, Object... args) {
		}

		public void flush() {
		}

		public void close() throws IOException {
		}

	};

	/**
	 * 書き込み用の仮想ファイルを取得します。
	 * 
	 * @param fname ファイル名
	 * @param fs ファイル管理クラス
	 */
	public static LineWriter out(String fname, AwkFiles fs) {
		if(fname.equals(STDOUT)) {
			return fs.getStdout();
		} else if(fname.equals(STDERR)) {
			return fs.getStderr();
		} else if(fname.equals(NULL)) {
			return NULLWRITER;
		} else {
			return null;
		}
	}

	/**
	 * 読み込み用の仮想ファイルを取得します。
	 * 
	 * @param fname ファイル名
	 * @param fs ファイル管理クラス
	 */
	public static RecordReader in(String fname, AwkFiles fs) {
		if(fname.equals(STDIN)) {
			return fs.getStdin();
		} else {
			return null;
		}
	}

}
