/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.pattern;

/**
 * パターンのマッチ状態です。<br />
 * <p>
 * パターンは最初NO_MATCH状態から始まります。<br />
 * 範囲指定されたとき、始まりのパターンにマッチするとIS_MATCHING状態に
 * なります。<br />
 * さらに終わりのパターンにマッチするとMATCHED状態になり、
 * マッチが終了します。
 * </p>
 * <p>
 * 1つのみのパターンのときはNO_MATCHからMATCHEDになります。
 * </p>
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public enum AwkMatchState {

	/**
	 * まだマッチが始まっていないことを示します。
	 */
	NO_MATCH,

	/**
	 * 範囲にマッチ中であることを示します。
	 */
	IS_MATCHING,

	/**
	 * マッチが終了したことを示します。
	 */
	MATCHED;

	/**
	 * まだマッチしていないときtrueを得ます。
	 */
	public boolean isNotMatched() {
		return this.equals(NO_MATCH);
	}

}
