/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.matrix;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.morilib.awk.matrix.IntPermutation;
import net.morilib.awk.matrix.IntSymmetricGroup;

public final class ArrayIntSymmetricGroup
implements IntSymmetricGroup {
    private static Map<Integer, IntSymmetricGroup> flyweight = new HashMap<Integer, IntSymmetricGroup>();
    private int cardinal;
    private IntPermutation identity;

    private ArrayIntSymmetricGroup(int card) {
        int[] id = new int[card];
        this.cardinal = card;
        int i = 0;
        while (i < card) {
            id[i] = i;
            ++i;
        }
        this.identity = new Ele(id, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntSymmetricGroup getInstance(int card) {
        if (card <= 0) {
            throw new IllegalArgumentException("cardinality must be positive");
        }
        Class<ArrayIntSymmetricGroup> clazz = ArrayIntSymmetricGroup.class;
        synchronized (ArrayIntSymmetricGroup.class) {
            IntSymmetricGroup res = flyweight.get(card);
            if (res == null) {
                res = new ArrayIntSymmetricGroup(card);
            }
            flyweight.put(card, res);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return res;
        }
    }

    public int getCardinal() {
        return this.cardinal;
    }

    public IntPermutation getIdentity() {
        return this.identity;
    }

    public IntPermutation newElement(int ... ps) {
        int[] fw = new int[this.cardinal];
        int[] in = new int[this.cardinal];
        if (ps == null) {
            throw new NullPointerException();
        }
        if (ps.length != this.cardinal) {
            throw new IllegalArgumentException("cardinality is not equal");
        }
        int i = 0;
        while (i < this.cardinal) {
            in[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.cardinal) {
            if (ps[i] <= 0 || ps[i] > this.cardinal) {
                throw new IndexOutOfBoundsException(String.valueOf(ps[i]));
            }
            fw[i] = ps[i] - 1;
            in[ps[i] - 1] = i;
            ++i;
        }
        i = 0;
        while (i < this.cardinal) {
            if (in[i] == -1) {
                throw new IllegalArgumentException("argument must be unique integer");
            }
            ++i;
        }
        return new Ele(fw, in);
    }

    public IntPermutation newElement(int[] i1, int[] i2) {
        int[] fw = new int[this.cardinal];
        int[] in = new int[this.cardinal];
        if (i1 == null || i2 == null) {
            throw new NullPointerException();
        }
        if (i1.length != this.cardinal) {
            throw new IllegalArgumentException("cardinality is not equal");
        }
        if (i2.length != this.cardinal) {
            throw new IllegalArgumentException("cardinality is not equal");
        }
        int i = 0;
        while (i < this.cardinal) {
            in[i] = -1;
            fw[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.cardinal) {
            if (i1[i] <= 0 || i1[i] > this.cardinal) {
                throw new IndexOutOfBoundsException(String.valueOf(i1[i]));
            }
            fw[i1[i] - 1] = i2[i] - 1;
            in[i2[i] - 1] = i1[i] - 1;
            ++i;
        }
        i = 0;
        while (i < this.cardinal) {
            if (in[i] == -1 || fw[i] == -1) {
                throw new IllegalArgumentException("argument must be unique integer");
            }
            ++i;
        }
        return new Ele(fw, in);
    }

    private class Ele
    implements IntPermutation {
        private int[] permutation;
        private int[] inverted;

        private Ele(int[] e, int[] inv) {
            this.permutation = e;
            this.inverted = inv;
        }

        public int get(int i) {
            if (i <= 0 || i > ArrayIntSymmetricGroup.this.cardinal) {
                throw new IndexOutOfBoundsException(String.valueOf(i));
            }
            return this.permutation[i - 1] + 1;
        }

        public int getCardinal() {
            return ArrayIntSymmetricGroup.this.cardinal;
        }

        public int getInverse(int i) {
            if (i <= 0 || i > ArrayIntSymmetricGroup.this.cardinal) {
                throw new IndexOutOfBoundsException(String.valueOf(i));
            }
            return this.inverted[i - 1] + 1;
        }

        public IntPermutation invert() {
            int[] fw = new int[ArrayIntSymmetricGroup.this.cardinal];
            int[] in = new int[ArrayIntSymmetricGroup.this.cardinal];
            int i = 0;
            while (i < ArrayIntSymmetricGroup.this.cardinal) {
                fw[i] = this.inverted[i];
                in[this.inverted[i]] = i;
                ++i;
            }
            return new Ele(fw, in);
        }

        public IntPermutation map(IntPermutation e) {
            int[] fw = new int[ArrayIntSymmetricGroup.this.cardinal];
            int[] in = new int[ArrayIntSymmetricGroup.this.cardinal];
            if (e == null) {
                throw new NullPointerException();
            }
            if (e.getCardinal() != ArrayIntSymmetricGroup.this.cardinal) {
                throw new IllegalArgumentException("cardinality is not equal");
            }
            int i = 0;
            while (i < ArrayIntSymmetricGroup.this.cardinal) {
                fw[i] = e.get(this.permutation[i] + 1) - 1;
                in[e.get((int)(this.permutation[i] + 1)) - 1] = i;
                ++i;
            }
            return new Ele(fw, in);
        }

        public boolean isEqualTo(IntPermutation e) {
            int card = this.getCardinal();
            if (e == null) {
                throw new NullPointerException();
            }
            if (card != e.getCardinal()) {
                return false;
            }
            int i = 0;
            while (i < card) {
                if (this.permutation[i] != e.get(i + 1) - 1) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (o instanceof Ele) {
                int[] fw2 = ((Ele)o).permutation;
                return Arrays.equals(this.permutation, fw2);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.permutation);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("(");
            int i = 0;
            while (i < this.permutation.length) {
                b.append(" ");
                b.append(i + 1).append("->");
                b.append(this.permutation[i] + 1);
                ++i;
            }
            b.append(" )");
            return b.toString();
        }
    }
}

