/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.matrix;

import net.morilib.awk.matrix.AbstractImmutableDoubleMatrix;
import net.morilib.awk.matrix.ArrayDoubleMatrix;
import net.morilib.awk.matrix.ArrayDoubleVector;
import net.morilib.awk.matrix.AwkMatrixException;
import net.morilib.awk.matrix.CombinationUtils;
import net.morilib.awk.matrix.DoubleMatrix;
import net.morilib.awk.matrix.DoubleVector;
import net.morilib.awk.matrix.LUDecomposedLMatrix;
import net.morilib.awk.matrix.LUDecomposedUMatrix;
import net.morilib.awk.matrix.PermutationDoubleMatrix;
import net.morilib.awk.misc.Strings;

public final class DoubleMatrices {
    private DoubleMatrices() {
    }

    public static void print(StringBuilder b, DoubleMatrix matrix) {
        String s;
        double d;
        int j;
        int l = -1;
        String dlm = "";
        int i = 0;
        while (i < matrix.rowSize()) {
            j = 0;
            while (j < matrix.columnSize()) {
                d = matrix.get(i, j);
                s = Double.toString(d);
                l = l < s.length() ? s.length() : l;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < matrix.rowSize()) {
            b.append("[");
            dlm = "";
            j = 0;
            while (j < matrix.columnSize()) {
                d = matrix.get(i, j);
                s = Double.toString(d);
                b.append(dlm).append(Strings.rpad(s, l));
                dlm = " ";
                ++j;
            }
            b.append("]\n");
            ++i;
        }
    }

    public static DoubleMatrix[] decomposeLU(DoubleMatrix a) throws AwkMatrixException {
        ArrayDoubleMatrix r = new ArrayDoubleMatrix(a);
        int parity = 0;
        if (a.rowSize() != a.columnSize()) {
            throw new AwkMatrixException("square matrix required");
        }
        int[] order = new int[a.rowSize()];
        int i = 0;
        while (i < a.rowSize()) {
            order[i] = i;
            ++i;
        }
        i = 0;
        while (i < a.rowSize() - 1) {
            int d = i;
            double mx = r.get(i, i);
            int j = i + 1;
            while (j < a.columnSize()) {
                if (mx < r.get(j, i)) {
                    d = j;
                    mx = r.get(j, i);
                }
                ++j;
            }
            if (d != i) {
                int swp = order[i];
                order[i] = order[d];
                order[d] = swp;
                ++parity;
                j = 0;
                while (j < a.columnSize()) {
                    double swp2 = r.get(i, j);
                    r.set(i, j, r.get(d, j));
                    r.set(d, j, swp2);
                    ++j;
                }
            }
            if (r.get(i, i) != 0.0) {
                j = i + 1;
                while (j < a.columnSize()) {
                    double x = r.get(j, i);
                    r.set(j, i, x /= r.get(i, i));
                    int k = i + 1;
                    while (k < a.rowSize()) {
                        double y = r.get(j, k);
                        r.set(j, k, y -= x * r.get(i, k));
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        int[] order1 = new int[order.length];
        i = 0;
        while (i < order.length) {
            order1[order[i]] = i;
            ++i;
        }
        return new DoubleMatrix[]{new PermutationDoubleMatrix(order1, parity), new LUDecomposedLMatrix(r), new LUDecomposedUMatrix(r)};
    }

    public static DoubleMatrix unmodifiable(DoubleMatrix x) {
        return x instanceof Umd ? x : new Umd(x);
    }

    private static DoubleVector mul(DoubleMatrix m, DoubleVector a) throws AwkMatrixException {
        if (m.columnSize() != a.size()) {
            throw new AwkMatrixException("cannot multiply the given matrix");
        }
        ArrayDoubleVector v = new ArrayDoubleVector(m.columnSize());
        int i = 0;
        while (i < m.rowSize()) {
            double x = 0.0;
            int k = 0;
            while (k < m.columnSize()) {
                x += m.get(i, k) * a.get(k);
                ++k;
            }
            v.set(i, x);
            ++i;
        }
        return v;
    }

    public static DoubleVector solve(DoubleMatrix a, DoubleVector b) throws AwkMatrixException {
        int j;
        if (a.rowSize() != a.columnSize()) {
            throw new AwkMatrixException("square matrix required");
        }
        if (a.rowSize() != b.size()) {
            throw new AwkMatrixException("size of vector is different");
        }
        DoubleMatrix[] dec = DoubleMatrices.decomposeLU(a);
        DoubleVector x = DoubleMatrices.mul(dec[0].inv(), b);
        int i = 1;
        while (i < a.rowSize()) {
            j = 0;
            while (j < i) {
                x.set(i, x.get(i) - x.get(j) * dec[1].get(i, j));
                ++j;
            }
            ++i;
        }
        i = a.rowSize() - 1;
        while (i >= 0) {
            if (dec[2].get(i, i) == 0.0) {
                throw new AwkMatrixException("this matrix is not regular");
            }
            x.set(i, x.get(i) / dec[2].get(i, i));
            j = i - 1;
            while (j >= 0) {
                x.set(j, x.get(j) - x.get(i) * dec[2].get(j, i));
                --j;
            }
            --i;
        }
        return x;
    }

    public static double determinantAllMinor(final DoubleMatrix a, int order) {
        final int[][] cmb = new int[1][];
        double res = 0.0;
        int len = Math.max(a.rowSize(), a.columnSize());
        AbstractImmutableDoubleMatrix minor = new AbstractImmutableDoubleMatrix(){

            public double get(int row, int column) {
                return a.get(cmb[0][row], cmb[0][column]);
            }

            public int rowSize() {
                return cmb[0].length;
            }

            public int columnSize() {
                return cmb[0].length;
            }

            public double determinant() throws AwkMatrixException {
                if (this.columnSize() != this.rowSize()) {
                    throw new AwkMatrixException("square matrix required");
                }
                DoubleMatrix[] dc = DoubleMatrices.decomposeLU(this);
                return dc[0].determinant() * dc[2].determinant();
            }
        };
        cmb[0] = CombinationUtils.initCombination(len, order);
        do {
            res += minor.determinant();
        } while ((cmb[0] = CombinationUtils.nextCombination(len, cmb[0])) != null);
        return res;
    }

    private static class Umd
    extends AbstractImmutableDoubleMatrix {
        private DoubleMatrix a;

        private Umd(DoubleMatrix a) {
            this.a = a;
        }

        public double get(int row, int column) {
            return this.a.get(row, column);
        }

        public int rowSize() {
            return this.a.rowSize();
        }

        public int columnSize() {
            return this.a.columnSize();
        }

        public double determinant() throws AwkMatrixException {
            return this.a.determinant();
        }

        public DoubleMatrix inv() throws AwkMatrixException {
            return this.a.inv();
        }
    }
}

