/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist.continuous;

import net.morilib.awk.stat.dist.AbstractContinuousDistribution;

public class CauchyDistribution
extends AbstractContinuousDistribution {
    private double x0;
    private double gamma;

    public CauchyDistribution(double x0, double gamma) {
        if (gamma <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.x0 = x0;
        this.gamma = gamma;
    }

    public double getX0() {
        return this.x0;
    }

    public double getGamma() {
        return this.gamma;
    }

    public double invCdf(double x) {
        if (x < 0.0 || x > 1.0) {
            return Double.NaN;
        }
        return this.gamma * Math.tan(Math.PI * (x - 0.5)) + this.x0;
    }

    public boolean isInSupport(double n) {
        return true;
    }

    public double supportInfimum() {
        return Double.NEGATIVE_INFINITY;
    }

    public double supportSupremum() {
        return Double.POSITIVE_INFINITY;
    }

    public double cdf(double x) {
        return Math.atan((x - this.x0) / this.gamma) / Math.PI + 0.5;
    }

    public double expectedValue() {
        return Double.NaN;
    }

    public double kurtosis() {
        return Double.NaN;
    }

    public double mode() {
        return this.x0;
    }

    public double skewness() {
        return Double.NaN;
    }

    public double variance() {
        return Double.NaN;
    }

    public double f(double x) {
        double k = (x - this.x0) / this.gamma;
        return 1.0 / (Math.PI * this.gamma * (1.0 + k * k));
    }
}

