/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist.continuous;

import net.morilib.awk.stat.dist.AbstractContinuousDistribution;
import net.morilib.awk.stat.special.Beta;
import net.morilib.awk.stat.special.Gamma;

public class TDistribution
extends AbstractContinuousDistribution {
    double nu;
    private final double lngammaNu1;
    private final double lngammaNu;
    private final double lnSqrtNuPi;

    public TDistribution(double nu) {
        if (nu <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.nu = nu;
        this.lngammaNu1 = Gamma.lnGamma((nu + 1.0) / 2.0);
        this.lngammaNu = Gamma.lnGamma(nu / 2.0);
        this.lnSqrtNuPi = Math.log(nu * Math.PI) / 2.0;
    }

    public double getNu() {
        return this.nu;
    }

    public double invCdf(double p) {
        if (p > 0.49 && p < 0.51) {
            double a = super.invCdf(0.49);
            double b = super.invCdf(0.51);
            return (b - a) / 0.02 * (p - 0.49) + a;
        }
        return super.invCdf(p);
    }

    public double f(double x) {
        return Math.exp(this.lngammaNu1 - this.lnSqrtNuPi - this.lngammaNu - (this.nu + 1.0) / 2.0 * Math.log(1.0 + x * x / this.nu));
    }

    public double cdf(double x) {
        double tau = this.nu / (x * x + this.nu);
        double r0 = 1.0 - Beta.I(tau, this.nu / 2.0, 0.5) / 2.0;
        return x < 0.0 ? 1.0 - r0 : r0;
    }

    public boolean isInSupport(double n) {
        return true;
    }

    public double supportSupremum() {
        return Double.POSITIVE_INFINITY;
    }

    public double supportInfimum() {
        return Double.NEGATIVE_INFINITY;
    }

    public double expectedValue() {
        return 0.0;
    }

    public double variance() {
        if (this.nu <= 1.0) {
            return Double.NaN;
        }
        if (this.nu <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return (this.nu - 2.0) / this.nu;
    }

    public double mode() {
        return 0.0;
    }

    public double median() {
        return 0.0;
    }

    public double skewness() {
        return 0.0;
    }

    public double kurtosis() {
        return this.nu > 4.0 ? 6.0 / (this.nu - 4.0) : Double.NaN;
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + (int)Double.doubleToLongBits(this.nu));
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof TDistribution) {
            TDistribution n = (TDistribution)o;
            return this.nu == n.nu;
        }
        return false;
    }
}

