/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.unix.glob;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.morilib.unix.charset.IntInterval;
import net.morilib.unix.charset.IntRange;
import net.morilib.unix.charset.UnixCharSetException;
import net.morilib.unix.charset.UnixCharSets;
import net.morilib.unix.glob.WildcardSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Wildcard {
    private IntRange[] chars;
    private List<Boolean> repeat;

    private Wildcard(IntRange[] chars, List<Boolean> repeat) {
        this.chars = chars;
        this.repeat = repeat;
    }

    public boolean matches(CharSequence cs) {
        HashSet<Integer> ss = new HashSet<Integer>();
        HashSet<Integer> ad = new HashSet<Integer>();
        ss.add(0);
        int p = 0;
        while (p < cs.length()) {
            Iterator i = ss.iterator();
            char c = cs.charAt(p);
            while (i.hasNext()) {
                int s = (Integer)i.next();
                if (this.chars[s].contains(c)) {
                    ad.add(s + 1);
                }
                if (this.repeat.get(s).booleanValue()) continue;
                i.remove();
            }
            ss.addAll(ad);
            ad.clear();
            if (ss.isEmpty()) break;
            ++p;
        }
        return ss.contains(this.chars.length - 1);
    }

    public static Wildcard compile(CharSequence pt) {
        ArrayList<IntRange> rl = new ArrayList<IntRange>();
        ArrayList<Boolean> rp = new ArrayList<Boolean>();
        boolean b = true;
        int p = 0;
        while (p < pt.length()) {
            char c = pt.charAt(p);
            switch (c) {
                case '*': {
                    if (b) {
                        rp.add(true);
                    }
                    b = false;
                    break;
                }
                case '?': {
                    rl.add(UnixCharSets.ALL_CHAR);
                    if (b) {
                        rp.add(false);
                    }
                    b = true;
                    break;
                }
                case '[': {
                    int z = p + 1;
                    while (true) {
                        if (z >= pt.length()) {
                            throw new WildcardSyntaxException();
                        }
                        if (pt.charAt(z) == ']') break;
                        ++z;
                    }
                    try {
                        rl.add(UnixCharSets.parse(pt.subSequence(p + 1, z)));
                    }
                    catch (UnixCharSetException e) {
                        throw new WildcardSyntaxException(e);
                    }
                    if (b) {
                        rp.add(false);
                    }
                    b = true;
                    p = z;
                    break;
                }
                default: {
                    rl.add(new IntInterval(c));
                    if (b) {
                        rp.add(false);
                    }
                    b = true;
                }
            }
            ++p;
        }
        if (b) {
            rp.add(false);
        }
        rl.add(IntRange.O);
        return new Wildcard(rl.toArray(new IntRange[0]), rp);
    }

    public static boolean matches(CharSequence pt, CharSequence cs) {
        return Wildcard.compile(pt).matches(cs);
    }
}

