/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.a;

import java.util.List;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

/**
 * 関数a.equalsの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class ArrayEquals extends AwkFunction {

	protected ArrayEquals() {
		super("equals", null);
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		AwkValue a, b, x, y;

		if(args.size() < 2) {
			return AwkInteger.TRUE;
		} else if((a = args.get(0)).isArray()) {
			for(int i = 1; i < args.size(); i++) {
				if(!(b = args.get(i)).isArray() ||
						!a.keys().equals(b.keys())) {
					return AwkInteger.FALSE;
				} else {
					for(String s : a.keys()) {
						x = a.referArray(s);
						y = b.referArray(s);
						if(x.compareTo(y, ns) != 0) {
							return AwkInteger.FALSE;
						}
					}
				}
			}
			return AwkInteger.TRUE;
		} else {
			return AwkInteger.FALSE;
		}
	}

}
