/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.misc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.IdentityHashMap;
import java.util.Map;
import net.morilib.sh.misc.IntTrie;

public class KeywordMatcher {
    IntTrie trie;
    Map<IntTrie, IntTrie> recover;
    boolean ci;

    private KeywordMatcher() {
    }

    void _compile1(boolean ci, IntTrie t, String s) {
        IntTrie x = t;
        int i = 0;
        while (i < s.length()) {
            int c;
            int d = s.charAt(i);
            int n = c = ci ? Character.toUpperCase(d) : d;
            if (x.contains(c)) {
                x = x.go(c);
            } else {
                IntTrie y = new IntTrie();
                this.recover.put(y, null);
                x.edges.put(c, y);
                y.parent = x;
                y.moji = d;
                x = y;
            }
            ++i;
        }
        x.accept = true;
    }

    void _recover(boolean ci, IntTrie t) {
        String v = t.getKeyword();
        int i = 1;
        while (i < v.length()) {
            block4: {
                IntTrie x = this.trie;
                int j = i;
                while (j < v.length()) {
                    int c = v.charAt(j);
                    if (ci) {
                        c = Character.toUpperCase(c);
                    }
                    if (x.contains(c)) {
                        x = x.go(c);
                        ++j;
                        continue;
                    }
                    break block4;
                }
                this.recover.put(t, x);
                return;
            }
            ++i;
        }
    }

    void _compile(boolean ci, String ... patterns) {
        this.trie = new IntTrie();
        this.recover = new IdentityHashMap<IntTrie, IntTrie>();
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this._compile1(ci, this.trie, s);
            ++n2;
        }
        for (IntTrie t : this.recover.keySet()) {
            this._recover(ci, t);
        }
    }

    public static KeywordMatcher compile(boolean caseInsensitive, String ... patterns) {
        KeywordMatcher p = new KeywordMatcher();
        p.ci = caseInsensitive;
        p._compile(p.ci, patterns);
        return p;
    }

    private IntTrie _next(int d, IntTrie t) {
        int c;
        int n = c = this.ci ? Character.toUpperCase(d) : d;
        if (t.contains(c)) {
            return t.go(c);
        }
        if ((t = this.recover.get(t)) == null) {
            t = this.trie;
        }
        return t.contains(c) ? t.go(c) : this.trie;
    }

    private IntTrie _nextnotrecover(int d, IntTrie t) {
        int c = this.ci ? Character.toUpperCase(d) : d;
        return t.contains(c) ? t.go(c) : null;
    }

    public String find(Reader r) throws IOException {
        int c;
        IntTrie t = this.trie;
        String s = null;
        while ((c = r.read()) >= 0) {
            if (t.isAccepted()) {
                s = t.getKeyword();
            }
            if (t.isDead()) {
                return s;
            }
            t = this._next(c, t);
        }
        return t.isAccepted() ? t.getKeyword() : s;
    }

    public String find(String s) {
        try {
            return this.find(new StringReader(s));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String matches(Reader r) throws IOException {
        int c;
        IntTrie t = this.trie;
        while ((c = r.read()) >= 0) {
            if ((t = this._nextnotrecover(c, t)) != null) continue;
            return null;
        }
        return t.isAccepted() ? t.getKeyword() : null;
    }

    public String matches(String s) {
        try {
            return this.matches(new StringReader(s));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String findWholeWord(Reader r) throws IOException {
        int c;
        boolean x = true;
        boolean y = false;
        IntTrie t = this.trie;
        String s = null;
        while ((c = r.read()) >= 0) {
            if (x && y && Character.isWhitespace(c)) {
                return s;
            }
            x = t.contains(c) ? x : Character.isWhitespace(c);
            y = (t = this._next(c, t)).isAccepted();
            if (!y) continue;
            s = t.getKeyword();
        }
        return x && t.isAccepted() ? t.getKeyword() : null;
    }

    public String findWholeWord(String s) {
        try {
            return this.findWholeWord(new StringReader(s));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

