/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.stat;

import net.morilib.awk.namespace.AwkNamespace;

/**
 * パッケージstatの関数を読み込みます。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/14
 */
public class AwkStatBuiltInLoader {

	/**
	 * 関数を読み込みます。
	 * 
	 * @param ns 名前空間
	 */
	public static void load(AwkNamespace ns) {
		AwkNamespace ss = ns.subnamespace("stat");

		ss.bindFunction("correlation", new Correlation());
		ss.bindFunction("covariance", new Covariance());
		ss.bindFunction("geometric", new GeometricMean());
		ss.bindFunction("harmonic", new HarmonicMean());
		ss.bindFunction("kurtosis", new Kurtosis());
		ss.bindFunction("mean", new Mean());
		ss.bindFunction("median", new Median());
		ss.bindFunction("mode", new Mode());
		ss.bindFunction("regression", new Regression());
		ss.bindFunction("skewness", new Skewness());
		ss.bindFunction("variance", new Variance());
		ss.bindFunction("varianceunbiased", new VarianceUnbiased());
		ss.bindFunction("percentile", new Percentile());

		ss.bindFunction("count", new Count());
		ss.bindFunction("histogram", new Histogram());

		ss.bindFunction("cdfbeta", new CdfBeta());
		ss.bindFunction("cdfbinomial", new CdfBinomial());
		ss.bindFunction("cdfcauchy", new CdfCauchy());
		ss.bindFunction("cdfchisquared", new CdfChiSquared());
		ss.bindFunction("cdfcontinuousuniform",
				new CdfContinuousUniform());
		ss.bindFunction("cdfcuniform", new CdfContinuousUniform());
		ss.bindFunction("cdfdiscreteuniform",
				new CdfDiscreteUniform());
		ss.bindFunction("cdfduniform", new CdfDiscreteUniform());
		ss.bindFunction("cdfexponential", new CdfExponential());
		ss.bindFunction("cdff", new CdfF());
		ss.bindFunction("cdfgamma", new CdfGamma());
		ss.bindFunction("cdfgeometric", new CdfGeometric());
		ss.bindFunction("cdfhypergeometric", new CdfHypergeometric());
		ss.bindFunction("cdflogistic", new CdfLogistic());
		ss.bindFunction("cdflognormal", new CdfLogNormal());
		ss.bindFunction("cdfnegativebinomial",
				new CdfNegativeBinomial());
		ss.bindFunction("cdfnormal", new CdfNormal());
		ss.bindFunction("cdfpoisson", new CdfPoisson());
		ss.bindFunction("cdft", new CdfT());

		ss.bindFunction("beta", new DistBeta());
		ss.bindFunction("binomial", new DistBinomial());
		ss.bindFunction("cauchy", new DistCauchy());
		ss.bindFunction("chisquared", new DistChiSquared());
		ss.bindFunction("continuousuniform",
				new DistContinuousUniform());
		ss.bindFunction("cuniform", new DistContinuousUniform());
		ss.bindFunction("discreteuniform", new DistDiscreteUniform());
		ss.bindFunction("duniform", new DistDiscreteUniform());
		ss.bindFunction("exponential", new DistExponential());
		ss.bindFunction("f", new DistF());
		ss.bindFunction("gamma", new DistGamma());
		ss.bindFunction("geometric", new DistGeometric());
		ss.bindFunction("hypergeometric", new DistHypergeometric());
		ss.bindFunction("logistic", new DistLogistic());
		ss.bindFunction("lognormal", new DistLogNormal());
		ss.bindFunction("negativebinomial",
				new DistNegativeBinomial());
		ss.bindFunction("normal", new DistNormal());
		ss.bindFunction("poisson", new DistPoisson());
		ss.bindFunction("t", new DistT());

		ss.bindFunction("qbeta", new QBeta());
		ss.bindFunction("qbinomial", new QBinomial());
		ss.bindFunction("qcauchy", new QCauchy());
		ss.bindFunction("qchisquared", new QChiSquared());
		ss.bindFunction("qcontinuousuniform",
				new QContinuousUniform());
		ss.bindFunction("qcuniform", new QContinuousUniform());
		ss.bindFunction("qdiscreteuniform", new QDiscreteUniform());
		ss.bindFunction("qduniform", new QDiscreteUniform());
		ss.bindFunction("qexponential", new QExponential());
		ss.bindFunction("qf", new QF());
		ss.bindFunction("qgamma", new QGamma());
		ss.bindFunction("qgeometric", new QGeometric());
		ss.bindFunction("qhypergeometric", new QHypergeometric());
		ss.bindFunction("qlogistic", new QLogistic());
		ss.bindFunction("qlognormal", new QLogNormal());
		ss.bindFunction("qnegativebinomial", new QNegativeBinomial());
		ss.bindFunction("qnormal", new QNormal());
		ss.bindFunction("qpoisson", new QPoisson());
		ss.bindFunction("qt", new QT());

		ss.bindFunction("rbeta", new RBeta());
		ss.bindFunction("rbinomial", new RBinomial());
		ss.bindFunction("rcauchy", new RCauchy());
		ss.bindFunction("rchisquared", new RChiSquared());
		ss.bindFunction("rcontinuousuniform",
				new RContinuousUniform());
		ss.bindFunction("rcuniform", new RContinuousUniform());
		ss.bindFunction("rdiscreteuniform", new RDiscreteUniform());
		ss.bindFunction("rduniform", new RDiscreteUniform());
		ss.bindFunction("rexponential", new RExponential());
		ss.bindFunction("rf", new RF());
		ss.bindFunction("rgamma", new RGamma());
		ss.bindFunction("rgeometric", new RGeometric());
		ss.bindFunction("rhypergeometric", new RHypergeometric());
		ss.bindFunction("rlogistic", new RLogistic());
		ss.bindFunction("rlognormal", new RLogNormal());
		ss.bindFunction("rnegativebinomial", new RNegativeBinomial());
		ss.bindFunction("rnormal", new RNormal());
		ss.bindFunction("rpoisson", new RPoisson());
		ss.bindFunction("rt", new RT());

		ss.bindFunction("chisquaredtest", new ChiSquaredTest());
		ss.bindFunction("t1test", new T1TestBoth());
		ss.bindFunction("t2test", new T2Test());
	}

}
