/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.builtin.stat;

import net.morilib.awk.builtin.AwkTernaryArgs;
import net.morilib.awk.builtin.stat.AwkStatUtils;
import net.morilib.awk.builtin.stat.AwkStatisticsException;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.stat.StatisticsUtils;
import net.morilib.awk.stat.dist.TDistribution;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public class T2Test
extends AwkTernaryArgs {
    public T2Test() {
        super("t2test");
    }

    public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1, AwkValue a2, AwkValue a3) {
        double significance = a3.toFloat();
        if (significance < 0.0 || significance > 1.0) {
            throw new AwkStatisticsException("Invaild significance");
        }
        double[] obsv = AwkStatUtils.toDoubleValues(a1);
        double[] ob2v = AwkStatUtils.toDoubleValues(a2);
        int num1 = obsv.length;
        int num2 = ob2v.length;
        double mean = StatisticsUtils.mean(obsv);
        double var1 = StatisticsUtils.unbiasedVariance(obsv);
        double mn2 = StatisticsUtils.mean(ob2v);
        double var2 = StatisticsUtils.unbiasedVariance(ob2v);
        double sv1 = var1 / (double)num1;
        double sv2 = var2 / (double)num2;
        double t = (mean - mn2) / Math.sqrt(sv1 + sv2);
        double df = (sv1 + sv2) * (sv1 + sv2) / (sv1 * sv1 / (double)(num1 - 1) + sv2 * sv2 / (double)(num2 - 1));
        TDistribution tdis = new TDistribution(df);
        double min = tdis.invCdf(significance / 2.0);
        double max = tdis.invCdf(1.0 - significance / 2.0);
        return min < t && t < max ? AwkInteger.ONE : AwkInteger.ZERO;
    }
}

