/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.expr;

import java.math.BigInteger;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class AwkReferField
extends AwkExpression {
    private BigInteger MI = BigInteger.valueOf(Integer.MAX_VALUE);
    private AwkExpression field;

    public AwkReferField(AwkExpression field) {
        this.field = field;
    }

    public AwkValue eval(AwkNamespace ns, AwkFiles o) {
        BigInteger b = this.field.eval(ns, o).toInteger();
        if (b.compareTo(this.MI) > 0 && b.signum() < 0) {
            return AwkUndefined.UNDEF;
        }
        return ns.referField(b.intValue());
    }

    public void assign(AwkNamespace ns, AwkValue v, AwkFiles f) {
        BigInteger b = this.field.eval(ns, f).toInteger();
        if (b.compareTo(this.MI) <= 0 && b.signum() >= 0) {
            ns.setField(b.intValue(), v.toString(ns));
        }
    }

    public boolean isLvalue() {
        return true;
    }
}

