/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.special;

import net.morilib.awk.stat.DoubleTransform;

public class HypergeometricFunction
implements DoubleTransform {
    private double[] a = new double[1];
    private double[] b = new double[1];

    public HypergeometricFunction(double a, double b) {
        this.a[0] = a;
        this.b[0] = b;
    }

    public double f(double x) {
        double t = 1.0;
        double r = 1.0;
        double s = Double.NaN;
        int n = 0;
        while (Double.isNaN(s) || r != s) {
            s = r;
            int k = 0;
            while (k < this.a.length && k < this.b.length) {
                t = t * (this.a[k] + (double)n) / (this.b[k] + (double)n);
                ++k;
            }
            while (k < this.a.length) {
                t *= this.a[k] + (double)n;
                ++k;
            }
            while (k < this.b.length) {
                t /= this.b[k] + (double)n;
                ++k;
            }
            if (Double.isNaN(r += (t = t / (double)(n + 1) * x))) break;
            ++n;
        }
        return r;
    }
}

