/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class AwkFloat
extends AwkValue {
    public static final AwkFloat NaN = new AwkFloat(Double.NaN);
    private double value;

    private AwkFloat(double d) {
        this.value = d;
    }

    public static AwkFloat valueOf(double d) {
        return new AwkFloat(d);
    }

    public double toFloat() {
        return this.value;
    }

    public BigInteger toInteger() {
        return new BigDecimal(this.value).toBigInteger();
    }

    public boolean toBoolean(AwkNamespace ns) {
        return this.value != 0.0;
    }

    public Number toReal() {
        return new Double(this.value);
    }

    public AwkValue toNumber() {
        return this;
    }

    public Pattern toRegex() {
        return Pattern.compile(Double.toString(this.value));
    }

    public Object toObject() {
        return new Double(this.value);
    }

    public boolean isFloat() {
        return true;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isReal() {
        return true;
    }

    public boolean isFloatValue() {
        return true;
    }

    public boolean isIntegerValue() {
        try {
            new BigDecimal(this.value).toBigIntegerExact();
            return true;
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    public boolean isRealValue() {
        return true;
    }

    public boolean isNegativeValue() {
        return this.value < 0.0;
    }

    public boolean isPositiveValue() {
        return this.value > 0.0;
    }

    public boolean isZeroValue() {
        return this.value == 0.0;
    }

    public boolean isString() {
        return false;
    }

    public boolean isRegex() {
        return false;
    }

    public boolean isFunction() {
        return false;
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isEmpty() {
        return this.value == 0.0;
    }

    public boolean isNumber() {
        return true;
    }

    public int hashCode() {
        return (int)Double.doubleToRawLongBits(this.value);
    }

    public boolean equals(Object o) {
        if (o instanceof AwkFloat) {
            return this.value == ((AwkFloat)o).value;
        }
        return false;
    }

    public String toString(AwkNamespace ns) {
        AwkValue v;
        if (ns == null || (v = ns.getRoot().find("OFMT")) == null) {
            return Double.toString(this.value);
        }
        return String.format(v.toString(), this.value);
    }

    public int compareTo(AwkValue o, AwkNamespace ns) {
        if (o instanceof AwkUndefined) {
            return 1;
        }
        if (o.isFloat() || o.isInteger()) {
            return this.value < o.toFloat() ? -1 : (this.value > o.toFloat() ? 1 : 0);
        }
        if (ns.isIgnoreCase()) {
            return this.toString(ns).compareToIgnoreCase(o.toString(ns));
        }
        return this.toString(ns).compareTo(o.toString(ns));
    }
}

