/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShExitException;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcessNumber;
import net.morilib.sh.ShRootShellEnvironment;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShTree;
import net.morilib.sh.ShTreeExpressionMachine;
import net.morilib.sh.builtin.ShBuiltInCommands;
import net.morilib.sh.file.ShSubFileSystem;
import net.morilib.sh.misc.XtraceStream;

public class ShTreeSubprocess
implements ShTree {
    private ShTree line;

    public ShTreeSubprocess(ShTree line) {
        this.line = line;
    }

    public int eval(ShEnvironment env, ShFileSystem fs, ShBuiltInCommands cmds, ShRuntime run, InputStream in, PrintStream out, PrintStream err, XtraceStream p) throws IOException, ShSyntaxException {
        try {
            ShRootShellEnvironment e2 = new ShRootShellEnvironment(env.getEnvironment());
            int r = this.line.eval(e2, new ShSubFileSystem(fs), cmds, run, in, out, err, p);
            int n = Integer.parseInt(e2.find("$"));
            ShProcessNumber.releaseNumber(n);
            return r;
        }
        catch (ShExitException e) {
            return e.getCode();
        }
    }

    public void compileInternally(ShTreeExpressionMachine.Builder b, Object brk, Object cnt) {
        b.add(this);
    }

    public String toString() {
        return "(" + this.line.toString() + ")";
    }
}

