/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.builtin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.misc.IOs;
import net.morilib.unix.misc.OptionIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShMv
implements ShProcess {
    private static final int BACKUP = 1;
    private static final int FORCE = 2;
    private static final int INTERACTIVE = 4;

    private int _mv1(ShFileSystem fs, BufferedReader rd, PrintStream err, int f, ShFile g, List<String> l) throws IOException {
        for (String s : l) {
            ShFile h = fs.getFile(s);
            int x = this._mv2(fs, rd, err, f, h, g);
            if (x == 0) continue;
            return x;
        }
        return 0;
    }

    private boolean _ren(ShFileSystem fs, int f, ShFile h, ShFile g) throws IOException {
        InputStream ins = null;
        PrintStream ous = null;
        ShFile j = fs.getFile(g + "~");
        if (g.isExist() && g.isFile() && !j.isExist() && (f & 1) != 0) {
            try {
                ins = h.getInputStream();
                ous = j.getPrintStream(false);
                IOs.copy(ins, ous);
            }
            finally {
                if (ins != null) {
                    ins.close();
                }
                if (ous != null) {
                    ous.close();
                }
            }
        }
        return h.renameTo(g);
    }

    private void _nrv(PrintStream err, ShFile h, ShFile g) {
        err.print("mv: cannot remove `");
        err.print(h.toString());
        err.print("' to `");
        err.print(g.toString());
        err.println("'");
    }

    private int _mv2(ShFileSystem fs, BufferedReader rd, PrintStream err, int f, ShFile h, ShFile g) throws IOException {
        if (!h.isExist()) {
            err.print("mv: ");
            err.print(h.toString());
            err.println(" not found.");
            return 2;
        }
        if (!g.isExist()) {
            if (!this._ren(fs, f, h, g)) {
                this._nrv(err, h, g);
                return 2;
            }
        } else if (g.isFile()) {
            if ((f & 4) != 0) {
                err.print("mv: overwrite `");
                err.print(g.toString());
                err.print("'? ");
                String s = rd.readLine();
                if (!s.equalsIgnoreCase("y") && !s.equalsIgnoreCase("yes")) {
                    return 0;
                }
            }
            if (!this._ren(fs, f, h, g)) {
                this._nrv(err, h, g);
                return 2;
            }
        } else if (g.isDirectory()) {
            ShFile j = fs.getFile(g, h.getName());
            if (!this._ren(fs, f, h, j)) {
                this._nrv(err, h, j);
                return 2;
            }
        } else {
            err.print("mv: ");
            err.print(h.toString());
            err.println(" is an invalid object.");
            return 2;
        }
        return 0;
    }

    @Override
    public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        String[] a = new String[args.length - 1];
        int f = 0;
        System.arraycopy(args, 1, a, 0, a.length);
        OptionIterator o = new OptionIterator("bfiuv", a);
        BufferedReader rd = new BufferedReader(new InputStreamReader(in, env.getCharset()));
        while (o.hasNext()) {
            switch (o.nextChar()) {
                case 'b': {
                    f |= 1;
                    break;
                }
                case 'f': {
                    f |= 2;
                    break;
                }
                case 'i': {
                    f |= 4;
                    break;
                }
                case 'u': {
                    break;
                }
                case 'v': {
                    break;
                }
                default: {
                    err.print("mv: unrecognized option: ");
                    err.println((char)o.getErrorOption());
                    return 2;
                }
            }
        }
        Iterator<String> t = o.filenameIterator();
        while (t.hasNext()) {
            l.add(t.next());
        }
        int n = l.size();
        if (n < 2) {
            err.println("mv: too few arguments");
            return 2;
        }
        if (n == 2) {
            ShFile h = fs.getFile((String)l.get(0));
            ShFile g = fs.getFile((String)l.get(1));
            return this._mv2(fs, rd, err, f, h, g);
        }
        ShFile g = fs.getFile((String)l.get(n - 1));
        if (g.isDirectory()) {
            return this._mv1(fs, rd, err, f, g, l.subList(0, n - 1));
        }
        err.print("mv: ");
        err.print((String)l.get(n - 1));
        err.println(" must be a directory.");
        return 2;
    }
}

