/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.matrix;

import net.morilib.awk.matrix.AbstractImmutableDoubleMatrix;

public class PermutationDoubleMatrix
extends AbstractImmutableDoubleMatrix {
    private int[] order;
    private int parity;

    PermutationDoubleMatrix(int[] order, int parity) {
        this.order = order;
        this.parity = parity;
    }

    public double get(int row, int column) {
        return this.order[row] == column ? 1.0 : 0.0;
    }

    public int rowSize() {
        return this.order.length;
    }

    public int columnSize() {
        return this.order.length;
    }

    public double determinant() {
        return (this.parity & 1) == 0 ? 1 : -1;
    }

    public PermutationDoubleMatrix inv() {
        int[] no = new int[this.order.length];
        int i = 0;
        while (i < no.length) {
            no[this.order[i]] = i;
            ++i;
        }
        return new PermutationDoubleMatrix(no, this.parity);
    }
}

