/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.m;

import net.morilib.awk.builtin.AwkMathFunction;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkValue;

public class MRe extends AwkMathFunction {

	protected MRe() {
		super("re");
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.builtin.AwkMathFunction#f(net.morilib.awk.value.AwkValue)
	 */
	protected AwkValue f(AwkValue x) {
		return AwkFloat.valueOf(x.toFloat());
	}

}
