/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.stat;

import java.util.Collection;

import net.morilib.awk.builtin.AwkTernaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.stat.StatisticsUtils;
import net.morilib.awk.stat.dist.TDistribution;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

/**
 * 関数stat.t1testleftの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class T1TestLeft extends AwkTernaryArgs {

	/**
	 * 
	 */
	public T1TestLeft() {
		super("t1testleft");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2, AwkValue a3) {
		Collection<AwkValue> c;
		TDistribution tdis;
		double[] obsv;
		double expected = a2.toFloat();
		double significance = a3.toFloat();
		double t, max, min, mean, var;
		int num, i = 0;

		if(significance < 0 || significance > 1) {
			throw new AwkStatisticsException("Invaild significance");
		}
		c    = a1.values();
		obsv = new double[c.size()];
		for(AwkValue a : c)  obsv[i++] = a.toFloat();
		num  = obsv.length;
		mean = StatisticsUtils.mean(obsv);
		var  = StatisticsUtils.variance(obsv);
		t    = (mean - expected) / Math.sqrt(var / num);
		tdis = new TDistribution(num - 1);
		min  = Double.NEGATIVE_INFINITY;
		max  = tdis.invCdf(significance);
		return (min < t && t < max) ? AwkInteger.ZERO : AwkInteger.ONE;
	}

}
