/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.parser;

/**
 * Cプリプロセッサの演算子です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class CpreOperator extends CpreToken {

	/**
	 * 加算演算子(+)です。
	 */
	public static final CpreOperator ADD = new CpreOperator("+");

	/**
	 * 減算演算子(-)です。
	 */
	public static final CpreOperator SUB = new CpreOperator("-");

	/**
	 * 乗算演算子(*)です。
	 */
	public static final CpreOperator MUL = new CpreOperator("*");

	/**
	 * 除算演算子(/)です。
	 */
	public static final CpreOperator DIV = new CpreOperator("/");

	/**
	 * 剰余演算子(%)です。
	 */
	public static final CpreOperator MOD = new CpreOperator("%");

	/**
	 * ビットごとのXOR演算子(^)です。
	 */
	public static final CpreOperator B_XOR = new CpreOperator("^");

	/**
	 * ビットごとのAND演算子(&)です。
	 */
	public static final CpreOperator B_AND = new CpreOperator("&");

	/**
	 * ビットごとのOR演算子(|)です。
	 */
	public static final CpreOperator B_OR  = new CpreOperator("|");

	/**
	 * 論理積演算子(&&)です。
	 */
	public static final CpreOperator L_AND = new CpreOperator("&&");

	/**
	 * 論理和演算子(||)です。
	 */
	public static final CpreOperator L_OR  = new CpreOperator("||");

	/**
	 * 論理否定演算子(!)です。
	 */
	public static final CpreOperator L_NOT = new CpreOperator("!");

	/**
	 * 条件演算子(?)です。
	 */
	public static final CpreOperator TRI1 = new CpreOperator("?");

	/**
	 * 条件演算子(:)です。
	 */
	public static final CpreOperator TRI2 = new CpreOperator(":");

	/**
	 * 左括弧です。
	 */
	public static final CpreOperator LPAREN = new CpreOperator("(");

	/**
	 * 右括弧です。
	 */
	public static final CpreOperator RPAREN = new CpreOperator(")");

	/**
	 * ビットごとのNOT演算子(~)です。
	 */
	public static final CpreOperator B_NOT = new CpreOperator("~");

	/**
	 * カンマ演算子です。
	 */
	public static final CpreOperator COMMA = new CpreOperator(",");

	/**
	 * 左シフト演算子(<<)です。
	 */
	public static final CpreOperator SHIFTL = new CpreOperator("<<");

	/**
	 * 右シフト演算子(>>)です。
	 */
	public static final CpreOperator SHIFTR = new CpreOperator(">>");

	/**
	 * defined演算子です。
	 */
	public static final CpreOperator DEFINED =
		new CpreOperator("defined");

	CpreOperator(String desc) {
		super(desc);
	}

}
