/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

public class ShRedirector extends ShToken {

	/**
	 * 
	 */
	public static final ShRedirector IN =
		new ShRedirector(ShRedirectType.IN, 0, -1);

	/**
	 * 
	 */
	public static final ShRedirector OUT =
		new ShRedirector(ShRedirectType.OUT, 1, -1);

	/**
	 * 
	 */
	public static final ShRedirector APPEND =
		new ShRedirector(ShRedirectType.APPEND, 1, -1);

	//
	private ShRedirectType type;
	private int source, destination;
	private String document;

	/**
	 * 
	 * @param type
	 * @param source
	 * @param destination
	 */
	public ShRedirector(ShRedirectType type, int source,
			int destination) {
		this.type        = type;
		this.source      = source;
		this.destination = destination;
		this.document    = null;
	}

	/**
	 * 
	 * @param type
	 * @param source
	 * @param destination
	 */
	public ShRedirector(String document) {
		this.type        = ShRedirectType.IN;
		this.source      = 0;
		this.destination = -1;
		this.document    = document;
	}

	/**
	 * 
	 * @return
	 */
	public ShRedirectType getType() {
		return type;
	}

	/**
	 * 
	 * @return
	 */
	public int getFDSource() {
		return source;
	}

	/**
	 * 
	 * @return
	 */
	public int getFDDestination() {
		return destination;
	}

	/**
	 * 
	 * @return
	 */
	public String getDocument() {
		return document;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isAppend() {
		return type.equals(ShRedirectType.APPEND);
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShToken#isFileRedirector()
	 */
	public boolean isFileRedirector() {
		return destination < 0 && document == null;
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShToken#isDescriptorCopier()
	 */
	public boolean isDescriptorCopier() {
		return destination >= 0;
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShToken#isHereDocument()
	 */
	public boolean isHereDocument() {
		return document != null;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		int r = 17;

		r = 31 * type.hashCode() + r;
		r = 31 * source + r;
		r = 31 * destination + r;
		return r;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object o) {
		ShRedirector r;

		if(o instanceof ShRedirector) {
			r = (ShRedirector)o;
			return (type.equals(r.type) &&
					source      == r.source &&
					destination == r.destination);
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		if(document != null) {
			return document;
		} else if(source < 0) {
			return "&>";
		} else if(destination < 0) {
			return source + type.toString();
		} else {
			return source + type.toString() + "&" + destination;
		}
	}

}
