/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;

import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShSecurityPolicy;
import net.morilib.sh.ShStat;

public class ShNullFileSystem implements ShFileSystem {

	private static final ShFile NULLFILE = new ShFile() {

		public Collection<ShFile> getFiles() {
			return Collections.emptySet();
		}

		public InputStream getInputStream() throws IOException {
			throw new IOException();
		}

		public long getLastModified() {
			return 0;
		}

		public String getName() {
			return "";
		}

		public PrintStream getPrintStream(
				boolean append) throws IOException {
			throw new IOException();
		}

		public ShProcess getProcess(String... args) {
			return null;
		}

		public boolean isDirectory() {
			return false;
		}

		public boolean isExecutable() {
			return false;
		}

		public boolean isExist() {
			return true;
		}

		public boolean isFile() {
			return true;
		}

		public boolean isReadable() {
			return false;
		}

		public boolean isWritable() {
			return false;
		}

		public boolean isHidden() {
			return false;
		}

		public boolean isZeroFile() {
			return true;
		}

		public boolean mkdir() {
			return false;
		}

		public boolean renameTo(ShFile f) {
			return false;
		}

		public ShFile toAbsolute() {
			return this;
		}

		public void setLastModified(long time) {
		}

		public boolean rmdir() {
			return false;
		}

		public boolean deleteFile() {
			return false;
		}

		public ShStat getStat() {
			return new ShStat();
		}

	};

	private ShFile realcur;

	public ShNullFileSystem() { }

	public ShFile getCurrentDirectory() {
		return realcur;
	}

	public void setCurrentDirectory(ShFile s) {
		realcur = s;
	}

	public ShFile getFile(String s) {
		return NULLFILE;
	}

	public ShFile getFile(String dir, String name) {
		return NULLFILE;
	}

	public ShFile getFile(ShFile dir, String name) {
		return NULLFILE;
	}

	public ShFile getRoot() {
		return NULLFILE;
	}

	public ShSecurityPolicy getSecurityPolicy() {
		return null;
	}

	public InputStream getProfile() {
		return null;
	}

	public InputStream getRc() {
		return null;
	}

	public ShFile getHome() {
		return NULLFILE;
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getNativeFile(java.lang.String)
	 */
	public ShFile getNativeFile(String s) {
		throw new UnsupportedOperationException();
	}

}
