/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.file;

import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShSecurityPolicy;
import net.morilib.sh.file.AbstractShEnvironment;
import net.morilib.sh.file.ShUnixEnvironment;
import net.morilib.sh.file.ShUnixFileSystem;
import net.morilib.sh.file.ShWindowsEnvironment;
import net.morilib.sh.file.ShWindowsFileSystem;
import net.morilib.sh.misc.OSInfo;

public class ShFileSystemFactory {
    private static final ShSecurityPolicy A = ShSecurityPolicy.ALL_PERMITTED;
    private static ShFileSystem instance = null;

    public static synchronized ShFileSystem getInstance() {
        if (instance == null) {
            if (OSInfo.OS.isWindows()) {
                String s = System.getenv("JSHHOME");
                if (s != null) {
                    instance = new ShWindowsFileSystem(s, A);
                } else {
                    String d = System.getenv("HOMEDRIVE");
                    if (d == null || (s = System.getenv("HOMEPATH")) == null || d.length() < 1) {
                        instance = new ShWindowsFileSystem("/", A);
                    } else {
                        StringBuffer b = new StringBuffer("/");
                        b.append(Character.toLowerCase(d.charAt(0)));
                        b.append('/');
                        b.append(s.replace('\\', '/'));
                        instance = new ShWindowsFileSystem(b.toString(), A);
                    }
                }
            } else {
                String s;
                instance = OSInfo.OS.isUNIX() ? ((s = System.getenv("JSHHOME")) != null ? new ShUnixFileSystem(s, A) : ((s = System.getenv("HOME")) != null ? new ShUnixFileSystem(s, A) : new ShUnixFileSystem("/", A))) : ((s = System.getenv("JSHHOME")) != null ? new ShUnixFileSystem(s, A) : new ShUnixFileSystem("/", A));
            }
        }
        return instance;
    }

    public static ShEnvironment getSystemEnvironment() {
        AbstractShEnvironment env = OSInfo.OS.isWindows() ? new ShWindowsEnvironment(ShFileSystemFactory.getInstance()) : (OSInfo.OS.isUNIX() ? new ShUnixEnvironment() : new ShUnixEnvironment());
        env.bind("IFS", " ");
        return env;
    }
}

