/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.unix.misc.OptionIterator;

public class ShGetopts implements ShProcess {

	private Map<ShEnvironment, OptionIterator> envs =
		new IdentityHashMap<ShEnvironment, OptionIterator>();

	private String nvl(String s) {
		return s != null ? s : "";
	}

	private String err(int c) {
		char[] a = new char[1];

		if(c < 0) {
			return "";
		} else {
			a[0] = (char)c;
			return new String(a);
		}
	}

	public int main(ShEnvironment env, ShFileSystem fs,
			InputStream stdin, PrintStream stdout, PrintStream stderr,
			String... args) throws IOException {
		List<String> l = new ArrayList<String>();
		char[] c = new char[1];
		OptionIterator o;
		int z;

		if(args.length < 3) {
			stderr.print(env.find("0"));
			stderr.println(": invaild arguments");
			return 2;
		} else if((o = envs.get(env)) == null) {
			try {
				z = Integer.valueOf(env.find("#"));
			} catch(NumberFormatException e) {
				z = 0;
			}
	
			for(int i = 1; i < z; i++)  l.add(env.find(i + ""));
			o = new OptionIterator(args[1], l.toArray(new String[0]));
			envs.put(env, o);
		}

		if(o.hasNext()) {
			c[0] = o.nextChar();
			env.bind(args[2], new String(c));
			env.bind("OPTARG", nvl(o.getArgument()));
			env.bind("OPTERR", err(o.getErrorOption()));
			env.bind("OPTIND", o.getIndex() + "");
			return 0;
		} else {
			env.bind("OPTIND", o.getIndex() + "");
			return 1;
		}
	}

}
