/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.value;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.morilib.awk.AwkCastException;
import net.morilib.awk.AwkSQLException;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkSQLCloseable;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwkResultSet
extends AwkValue
implements AwkSQLCloseable {
    private ResultSet result;
    private AwkValue value = null;

    public AwkResultSet(ResultSet rs) {
        this.result = rs;
    }

    private boolean setvalue() throws SQLException {
        if (this.result.next()) {
            AwkArray a = new AwkArray();
            ResultSetMetaData md = this.result.getMetaData();
            int i = 1;
            while (i <= md.getColumnCount()) {
                String s = md.getColumnName(i);
                String v = this.result.getString(i);
                a.putArray(s, AwkString.valueOf(v));
                ++i;
            }
            this.value = a;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<AwkValue> iterator() {
        return new Iterator<AwkValue>(){

            @Override
            public boolean hasNext() {
                try {
                    return AwkResultSet.this.value != null || AwkResultSet.this.setvalue();
                }
                catch (SQLException e) {
                    throw new AwkSQLException(e);
                }
            }

            @Override
            public AwkValue next() {
                try {
                    if (AwkResultSet.this.value == null && !AwkResultSet.this.setvalue()) {
                        throw new NoSuchElementException();
                    }
                    AwkValue v = AwkResultSet.this.value;
                    AwkResultSet.this.value = null;
                    return v;
                }
                catch (SQLException e) {
                    throw new AwkSQLException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String toString(AwkNamespace ns) {
        return "<result set>";
    }

    @Override
    public boolean toBoolean(AwkNamespace ns) {
        return true;
    }

    @Override
    public Object toObject() {
        return this.result;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isReal() {
        return false;
    }

    @Override
    public boolean isIntegerValue() {
        return false;
    }

    @Override
    public boolean isFloatValue() {
        return false;
    }

    @Override
    public boolean isRealValue() {
        return false;
    }

    @Override
    public boolean isPositiveValue() {
        return false;
    }

    @Override
    public boolean isZeroValue() {
        return false;
    }

    @Override
    public boolean isNegativeValue() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isRegex() {
        return false;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public int compareTo(AwkValue v, AwkNamespace ns) {
        throw new AwkCastException(this + " is not comparable");
    }

    @Override
    public void closeSQL() throws SQLException {
        this.result.close();
    }
}

