/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.InputStream;
import java.io.PrintStream;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShStat;

public abstract class AbstractShVirtualDirectory
implements ShFile {
    private String current;
    private ShFile parent;

    public AbstractShVirtualDirectory(ShFile parentFile, String currentName) {
        if (parentFile != null && currentName == null) {
            throw new NullPointerException();
        }
        this.parent = parentFile;
        this.current = currentName;
    }

    public InputStream getInputStream() {
        return null;
    }

    public String getName() {
        return this.current != null ? this.current : "";
    }

    public PrintStream getPrintStream(boolean append) {
        return null;
    }

    public boolean isDirectory() {
        return true;
    }

    public boolean isExecutable() {
        return true;
    }

    public boolean isExist() {
        return true;
    }

    public boolean isFile() {
        return false;
    }

    public long getLastModified() {
        return Long.MIN_VALUE;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isZeroFile() {
        return false;
    }

    public ShProcess getProcess() {
        return null;
    }

    public ShFile toAbsolute() {
        return this;
    }

    public ShFile toCanonical() {
        return this;
    }

    public boolean mkdir() {
        return false;
    }

    public boolean renameTo(ShFile f) {
        return false;
    }

    public void setLastModified(long time) {
    }

    public boolean rmdir() {
        return false;
    }

    public boolean deleteFile() {
        return false;
    }

    public ShStat getStat() {
        return new ShStat(this.toString(), 0L, 0L, 15);
    }

    public String toString() {
        return String.valueOf(this.parent != null ? this.parent.toString() : "") + "/" + this.getName();
    }
}

