/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShRootEnvironment;

public class ShSubEnvironment
extends ShRootEnvironment {
    private ShEnvironment env;
    private Map<String, String> map;
    private Map<String, ShEnvironment.Attributes> attrs;

    public ShSubEnvironment(ShEnvironment env) {
        this.env = env;
        this.map = new HashMap<String, String>();
        this.attrs = new HashMap<String, ShEnvironment.Attributes>();
    }

    public void bind(String name, String value) {
        this.map.put(name, value);
        this.setpath();
    }

    public boolean contains(String name) {
        return this.map.containsKey(name) || this.env.contains(name);
    }

    public void export(String name) {
        if (!this.env.contains(name)) {
            this.map.put(name, "");
        }
    }

    public String find(String name) {
        return this.map.containsKey(name) ? this.map.get(name) : this.env.find(name);
    }

    public ShEnvironment getEnvironment() {
        return this;
    }

    public boolean isReadonly(String name) {
        ShEnvironment.Attributes a = this.attrs.get(name);
        if (a != null) {
            return a.isReadonly();
        }
        if (this.map.containsKey(name)) {
            return false;
        }
        return this.env.isReadonly(name);
    }

    public void put(String name, String value) {
        this.map.put(name, value);
    }

    public void setReadonly(String name) {
        if (this.map.containsKey(name)) {
            this.attrs.put(name, READONLY);
        } else {
            this.env.setReadonly(name);
        }
    }

    public Properties toProperties() {
        Properties p = this.env.toProperties();
        for (Map.Entry<String, String> e : this.map.entrySet()) {
            p.setProperty(e.getKey(), e.getValue());
        }
        return p;
    }

    public void unbind(String name) {
        if (this.map.containsKey(name)) {
            this.map.remove(name);
        } else {
            this.env.unbind(name);
        }
    }
}

