/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.builtin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileGetter;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.file.ShFileSystemFactory;
import net.morilib.sh.misc.IOs;
import net.morilib.sh.misc.KeywordMatcher;
import net.morilib.sh.misc.RingBuffer;
import net.morilib.unix.misc.OptionIterator;
import net.morilib.unix.regex.BasicPattern;

public class ShGrep
implements ShProcess {
    private static final int RE_JAVA = 0;
    private static final int RE_BASIC = 1;
    private static final int RE_EXTEND = 2;
    private static final int RE_FIXED = 3;
    private static final int RE_MASK = 3;
    private static final int PRINT_BEFORE = 4;
    private static final int PRINT_AFTER = 8;
    private static final int PRINT_OFFSET = 16;
    private static final int PRINT_LINENO = 32;
    private static final int PRINT_FILENAME = 64;
    private static final int IGNORE_CASE = 128;
    private static final int SUPPRESS_FILENAME = 256;
    private static final int QUIET = 512;
    private static final int SUPPRESS_ERROR = 1024;
    private static final int INVERT_MATCH = 2048;
    private static final int WHOLE_WORD = 4096;
    private static final int WHOLE_LINE = 8192;
    private static final int PRINT_MATCH_LINES = 16384;
    private static final int PRINT_ONLY_FILENAME = 32768;
    private static final String STDIN = "(stdin)";

    private void perror(PrintStream err, Flags f, String n, String s) {
        if ((f.flags & 0x400) == 0) {
            err.print(n);
            err.print(": ");
            err.println(s);
        }
    }

    private void print(PrintStream out, Flags f, String s) {
        if ((f.flags & 0x200) == 0) {
            out.print(s);
        }
    }

    private void print(PrintStream out, Flags f, int s) {
        if ((f.flags & 0x200) == 0) {
            out.print(s);
        }
    }

    private void println(PrintStream out, Flags f, String s) {
        if ((f.flags & 0x200) == 0) {
            out.println(s);
        }
    }

    private void println(PrintStream out, Flags f, int s) {
        if ((f.flags & 0x200) == 0) {
            out.println(s);
        }
    }

    private void printhead(PrintStream out, Flags f, int n, String s) {
        if ((f.flags & 0x40) != 0) {
            this.print(out, f, s);
            this.print(out, f, ":");
        }
        if ((f.flags & 0x20) != 0) {
            this.print(out, f, n);
            this.print(out, f, ":");
        }
    }

    Mt _matcher(Flags f) {
        switch (f.flags & 0x3003) {
            case 0: {
                return new MtJ1(f.pattern, (f.flags & 0x80) != 0);
            }
            case 8192: 
            case 12288: {
                return new MtJ2(f.pattern, (f.flags & 0x80) != 0);
            }
            case 4096: {
                return new MtJ3(f.pattern, (f.flags & 0x80) != 0);
            }
            case 1: {
                return new MtG1(f.pattern, (f.flags & 0x80) != 0);
            }
            case 8193: 
            case 12289: {
                return new MtG2(f.pattern, (f.flags & 0x80) != 0);
            }
            case 4097: {
                return new MtG3(f.pattern, (f.flags & 0x80) != 0);
            }
            case 2: {
                return new MtJ1(f.pattern, (f.flags & 0x80) != 0);
            }
            case 8194: 
            case 12290: {
                return new MtJ2(f.pattern, (f.flags & 0x80) != 0);
            }
            case 4098: {
                return new MtJ3(f.pattern, (f.flags & 0x80) != 0);
            }
            case 3: {
                return new MtF1(f.pattern, (f.flags & 0x80) != 0);
            }
            case 8195: 
            case 12291: {
                return new MtF2(f.pattern, (f.flags & 0x80) != 0);
            }
            case 4099: {
                return new MtF3(f.pattern, (f.flags & 0x80) != 0);
            }
        }
        throw new RuntimeException();
    }

    boolean _grep(Flags f, InputStream in, PrintStream out, String n, Charset cset) throws IOException {
        String s;
        int a = -1;
        int l = 1;
        int c = 0;
        Mt m = this._matcher(f);
        BufferedReader d = new BufferedReader(new InputStreamReader(in, cset));
        RingBuffer r = new RingBuffer((f.flags & 4) != 0 ? f.around + 1 : 1);
        while ((s = d.readLine()) != null) {
            r.add(s);
            boolean b = m.matches(s);
            if (b == ((f.flags & 0x800) == 0)) {
                ++c;
                if ((f.flags & 0x8000) != 0) {
                    this.println(out, f, n);
                    return true;
                }
                if ((f.flags & 0x4000) == 0 && (f.flags & 0x200) == 0) {
                    for (String t : r.toList()) {
                        this.printhead(out, f, l, n);
                        this.println(out, f, t);
                    }
                }
                r.clear();
                a = 0;
            } else if (a >= 0 && a < f.around && (f.flags & 8) != 0) {
                this.printhead(out, f, l, n);
                this.println(out, f, s);
                ++a;
            } else {
                a = -1;
            }
            ++l;
        }
        if ((f.flags & 0x4000) != 0) {
            if ((f.flags & 0x40) != 0) {
                this.print(out, f, n);
                this.print(out, f, ":");
            }
            this.println(out, f, c);
        }
        return c > 0;
    }

    int main(ShEnvironment env, ShFileSystem fs, ShFileGetter gt, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        Flags f = new Flags();
        InputStream m = null;
        boolean z = false;
        OptionIterator o = new OptionIterator("A:B:C:EFGJbchHilnqsvwxe:f:", args);
        block32: while (o.hasNext()) {
            switch (o.nextChar()) {
                case 'A': {
                    try {
                        f.flags |= 8;
                        f.around = Integer.parseInt(o.getArgument());
                    }
                    catch (NumberFormatException e) {
                        this.perror(err, f, args[0], "number required");
                    }
                    continue block32;
                }
                case 'B': {
                    try {
                        f.flags |= 4;
                        f.around = Integer.parseInt(o.getArgument());
                    }
                    catch (NumberFormatException e) {
                        this.perror(err, f, args[0], "number required");
                    }
                    continue block32;
                }
                case 'C': {
                    try {
                        f.flags |= 0xC;
                        f.around = Integer.parseInt(o.getArgument());
                        break;
                    }
                    catch (NumberFormatException e) {
                        this.perror(err, f, args[0], "number required");
                        return 2;
                    }
                }
                case 'E': {
                    f.flags = f.flags & 0xFFFFFFFC | 2;
                    break;
                }
                case 'F': {
                    f.flags = f.flags & 0xFFFFFFFC | 3;
                    break;
                }
                case 'G': {
                    f.flags = f.flags & 0xFFFFFFFC | 1;
                    break;
                }
                case 'J': {
                    f.flags &= 0xFFFFFFFC;
                    break;
                }
                case 'b': {
                    f.flags |= 0x10;
                    break;
                }
                case 'n': {
                    f.flags |= 0x20;
                    break;
                }
                case 'c': {
                    f.flags |= 0x4000;
                    break;
                }
                case 'e': {
                    f.pattern = o.getArgument();
                    break;
                }
                case 'f': {
                    InputStreamReader r = new InputStreamReader(gt.get(fs, o.getArgument()).getInputStream());
                    f.pattern = IOs.toString(r);
                    f.pattern = f.pattern.replaceFirst("\n+$", "");
                    break;
                }
                case 'h': {
                    f.flags |= 0x100;
                    break;
                }
                case 'H': {
                    f.flags |= 0x40;
                    break;
                }
                case 'i': {
                    f.flags |= 0x80;
                    break;
                }
                case 'l': {
                    f.flags |= 0x8000;
                    break;
                }
                case 'q': {
                    f.flags |= 0x200;
                    break;
                }
                case 's': {
                    f.flags |= 0x400;
                    break;
                }
                case 'v': {
                    f.flags |= 0x800;
                    break;
                }
                case 'w': {
                    f.flags |= 0x1000;
                    break;
                }
                case 'x': {
                    f.flags |= 0x2000;
                    break;
                }
                default: {
                    this.perror(err, f, args[0], "invalid argument");
                    return 2;
                }
            }
        }
        int x = o.getIndex();
        Iterator<String> q = o.filenameIterator();
        if (f.pattern == null) {
            if (!q.hasNext()) {
                this.perror(err, f, "grep", "pattern required");
                return 2;
            }
            f.pattern = q.next();
            ++x;
        }
        if (args.length - x >= 1 && (f.flags & 0x100) == 0) {
            f.flags |= 0x40;
        }
        if (q.hasNext()) {
            while (q.hasNext()) {
                String s = q.next();
                if (s.equals("-")) {
                    z = this._grep(f, in, out, STDIN, env.getCharset()) | z;
                    continue;
                }
                try {
                    m = gt.get(fs, s).getInputStream();
                    z = this._grep(f, m, out, s, env.getCharset()) | z;
                }
                finally {
                    if (m != null) {
                        m.close();
                    }
                    m = null;
                }
            }
        } else {
            z = this._grep(f, in, out, STDIN, env.getCharset());
        }
        return z ? 0 : 1;
    }

    public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        String[] a = new String[args.length - 1];
        System.arraycopy(args, 1, a, 0, a.length);
        return this.main(env, fs, ShFileGetter.SH_FILE, in, out, err, a);
    }

    public static void main(String[] args) {
        try {
            System.exit(new ShGrep().main(ShFileSystemFactory.getSystemEnvironment(), ShFileSystemFactory.getInstance(), ShFileGetter.SH_NATIVE, System.in, System.out, System.err, args));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Flags {
        String pattern;
        int flags = 0;
        int around = 1;

        private Flags() {
        }
    }

    private static abstract class Mt {
        private Mt() {
        }

        abstract boolean matches(String var1);
    }

    private static class MtF1
    extends Mt {
        private KeywordMatcher m;

        MtF1(String p, boolean ci) {
            String s = p.replaceFirst("\n+$", "");
            String[] a = s.split("\n+");
            this.m = KeywordMatcher.compile(ci, a);
        }

        boolean matches(String s) {
            return this.m.find(s) != null;
        }
    }

    private static class MtF2
    extends Mt {
        private KeywordMatcher m;

        MtF2(String p, boolean ci) {
            String s = p.replaceFirst("\n+$", "");
            String[] a = s.split("\n+");
            this.m = KeywordMatcher.compile(ci, a);
        }

        boolean matches(String s) {
            return this.m.matches(s) != null;
        }
    }

    private static class MtF3
    extends Mt {
        private KeywordMatcher m;

        MtF3(String p, boolean ci) {
            String s = p.replaceFirst("\n+$", "");
            String[] a = s.split("\n+");
            this.m = KeywordMatcher.compile(ci, a);
        }

        boolean matches(String s) {
            return this.m.findWholeWord(s) != null;
        }
    }

    private static class MtG1
    extends Mt {
        private BasicPattern mt;

        MtG1(String p, boolean ci) {
            this.mt = BasicPattern.compile(p, ci ? 2 : 0);
        }

        boolean matches(String s) {
            return this.mt.matcher(s).matches();
        }
    }

    private static class MtG2
    extends Mt {
        private BasicPattern mt;

        MtG2(String p, boolean ci) {
            this.mt = BasicPattern.compile(p, ci ? 2 : 0);
        }

        boolean matches(String s) {
            return this.mt.matcher(s).matchesAll();
        }
    }

    private static class MtG3
    extends Mt {
        private BasicPattern mt;

        MtG3(String p, boolean ci) {
            this.mt = BasicPattern.compile(p, ci ? 2 : 0);
        }

        boolean matches(String s) {
            return this.mt.matcher(s).matchesWholeWord();
        }
    }

    private static class MtJ1
    extends Mt {
        private Pattern mt;

        MtJ1(String p, boolean ci) {
            this.mt = Pattern.compile(p, ci ? 2 : 0);
        }

        boolean matches(String s) {
            return this.mt.matcher(s).find();
        }
    }

    private static class MtJ2
    extends Mt {
        private Pattern mt;

        MtJ2(String p, boolean ci) {
            this.mt = Pattern.compile(p, ci ? 2 : 0);
        }

        boolean matches(String s) {
            return this.mt.matcher(s).matches();
        }
    }

    private static class MtJ3
    extends Mt {
        private Pattern mt;

        MtJ3(String p, boolean ci) {
            this.mt = Pattern.compile(p, ci ? 2 : 0);
        }

        boolean matches(String s) {
            int c;
            Matcher m = this.mt.matcher(s);
            return !(!m.find() || (c = m.start()) != 0 && !Character.isWhitespace(s.charAt(--c)) || (c = m.end()) != s.length() && !Character.isWhitespace(s.charAt(++c)));
        }
    }
}

