/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.exe;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShCommandNotFoundException;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFacade;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShPromptReader;
import net.morilib.sh.ShRootShellEnvironment;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShSignal;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;
import net.morilib.sh.ShTree;
import net.morilib.sh.ShTreeExpressionMachine;
import net.morilib.sh.ShTrees;
import net.morilib.sh.exe.Sh;
import net.morilib.sh.misc.IOs;
import net.morilib.sh.misc.XtraceStream;
import net.morilib.unix.misc.OptionIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShTreeSh
implements ShTree {
    private List<ShToken> args;

    ShTreeSh(List<ShToken> args) {
        this.args = args;
    }

    @Override
    public void compileInternally(ShTreeExpressionMachine.Builder b, Object brk, Object cnt) {
        b.add(this);
    }

    private void _setarg(ShEnvironment n, Iterator<String> a) {
        int i = 1;
        while (a.hasNext()) {
            n.put(String.valueOf(i), a.next());
            ++i;
        }
    }

    @Override
    public int eval(ShEnvironment env, ShFileSystem fs, ShBuiltInCommands cmds, ShRuntime run, InputStream in, PrintStream out, PrintStream err, XtraceStream pr) throws IOException, ShSyntaxException {
        String s;
        ArrayList<String> l = new ArrayList<String>();
        InputStream ins = null;
        ShRootShellEnvironment n = new ShRootShellEnvironment(env.getEnvironment());
        for (ShToken t : this.args) {
            l.add(ShTrees.substitute(env, run, fs, err, pr, t));
        }
        try {
            OptionIterator o = new OptionIterator("Cfnuvxo:c:s", true, l);
            while (o.hasNext()) {
                switch (o.nextChar()) {
                    case 'C': {
                        n.set("noclobber", !o.isPlus());
                        break;
                    }
                    case 'f': {
                        n.set("noglob", !o.isPlus());
                        break;
                    }
                    case 'n': {
                        n.set("noexec", !o.isPlus());
                        break;
                    }
                    case 'u': {
                        n.set("nounset", !o.isPlus());
                        break;
                    }
                    case 'v': {
                        n.set("verbose", !o.isPlus());
                        break;
                    }
                    case 'x': {
                        n.set("xtrace", !o.isPlus());
                        break;
                    }
                    case 'c': {
                        String s2 = o.getArgument();
                        Iterator<String> a = o.filenameIterator();
                        this._setarg(n, a);
                        int n2 = run.eval(n, fs, in, out, err, pr, s2);
                        return n2;
                    }
                    case 's': {
                        String s3 = o.getArgument();
                        Iterator<String> a = o.filenameIterator();
                        this._setarg(n, a);
                        int n3 = Sh.interactive(n, fs, cmds, run, in, out, err, pr, new ShPromptReader(in, env, pr));
                        return n3;
                    }
                }
            }
            ShFacade.execute((ShEnvironment)n, fs, cmds, run, fs.getRc(), ins, out, err, pr);
            Iterator<String> a = o.filenameIterator();
            if (a.hasNext()) {
                String s4 = a.next();
                ins = fs.getFile(s4).getInputStream();
                s4 = IOs.toString(new InputStreamReader(ins, env.getCharset()));
                this._setarg(n, a);
                int n4 = run.eval(n, fs, in, out, err, pr, s4);
                return n4;
            }
            int n5 = Sh.interactive(env, fs, cmds, run, in, out, err, pr);
            return n5;
        }
        catch (IOException e) {
            s = env.getTrap(ShSignal.IO);
            if (s != null) {
                try {
                    Sh.RUNTIME.eval(env, fs, in, out, err, pr, s);
                }
                catch (ShCommandNotFoundException e1) {
                    err.print("jsh");
                    err.print(": command not found: ");
                    err.println(e1.getName());
                }
                return 72;
            }
            throw e;
        }
        {
            finally {
                if (ins != null) {
                    ins.close();
                }
            }
        }
        finally {
            s = env.getTrap(ShSignal.EXIT);
            if (s != null) {
                run.eval(env, fs, in, out, err, pr, s);
            }
        }
    }
}

