/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.morilib.sh.AbstractShFileSystem;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShSecurityPolicy;
import net.morilib.sh.file.ShUnixRealFile;

public class ShUnixFileSystem
extends AbstractShFileSystem {
    private String home;
    private ShSecurityPolicy security;

    public ShUnixFileSystem(String home, ShSecurityPolicy security) {
        this.home = home;
        this.security = security;
    }

    public ShFile getFile(String s) {
        String v;
        String t = s.replaceFirst("^/+", "/");
        t = t.replaceFirst("/+$", "");
        t = t.replaceAll("^(/\\.\\.)+", "/");
        do {
            v = t;
        } while (!(t = t.replaceAll("/[^/]+/\\.\\.", "")).equals(v));
        t = t.replaceAll("(/\\.)+/", "/");
        if ((t = t.replaceAll("(/\\.)+$", "")).length() == 0) {
            return this.getCurrentDirectory();
        }
        if (t.charAt(0) == '/') {
            return new ShUnixRealFile(this, t, new File(t));
        }
        if (this.realcur == null) {
            return new ShUnixRealFile(this, "/" + t, new File("/", t));
        }
        if (this.getCurrentDirectory().toString().equals("/")) {
            return new ShUnixRealFile(this, "/" + t, new File("/", t));
        }
        return new ShUnixRealFile(this, this.getCurrentDirectory() + "/" + t, new File(this.getCurrentDirectory().toString(), t));
    }

    public ShFile getFile(String dir, String name) {
        return this.getFile(String.valueOf(dir) + "/" + name);
    }

    public ShFile getFile(ShFile dir, String name) {
        return this.getFile(String.valueOf(dir.toString()) + "/" + name);
    }

    public ShFile getRoot() {
        return new ShUnixRealFile(this, "/", new File("/"));
    }

    public ShSecurityPolicy getSecurityPolicy() {
        return this.security;
    }

    public InputStream getProfile() {
        try {
            ShFile f = this.getFile(this.home, ".jsh_profile");
            if (f.isFile() || (f = this.getFile(this.home, ".jsh_login")).isFile() || (f = this.getFile(this.home, ".profile")).isFile()) {
                return f.getInputStream();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public InputStream getRc() {
        try {
            ShFile f = this.getFile(this.home, ".jshrc");
            if (f.isFile()) {
                return f.getInputStream();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public ShFile getHome() {
        return this.getFile(this.home);
    }

    public ShFile getNativeFile(String s) {
        File x = new File(s);
        try {
            x = x.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ShUnixRealFile(this, x.toString(), x);
    }

    public ShFile searchPath(ShEnvironment env, String name) {
        List<String> p = env.getPath();
        if (name.length() == 0 || name.charAt(0) == '/') {
            return this.getFile(name);
        }
        for (String t : p) {
            ShFile f = this.getFile(t);
            if (f == null || !f.isDirectory() || (f = this.getFile(t, name)) == null || !f.isExecutable()) continue;
            return f;
        }
        return null;
    }
}

