/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.file;

import java.io.File;
import java.util.regex.Pattern;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.file.ShOSProcess;
import net.morilib.sh.file.ShRealFile;
import net.morilib.sh.misc.FileTypeUtils;

public class ShWindowsRealFile
extends ShRealFile {
    private static final Pattern _EXE = Pattern.compile("\\.exe$", 2);

    public ShWindowsRealFile(ShFileSystem fs, String virtualpath, File file) {
        super(fs, virtualpath, file);
    }

    public ShProcess getProcess() {
        if (_EXE.matcher(this.file.getName()).find() && FileTypeUtils.guessWindowsExecutable(this.file) && !this.filesystem.getSecurityPolicy().denyExecuteOSCommand()) {
            return new ShOSProcess(this);
        }
        String[] a = FileTypeUtils.parseShebang(this.file);
        if (a != null && a[1].equals("jsh")) {
            return null;
        }
        if (a != null && a[0] != null && a[1] != null) {
            return null;
        }
        return null;
    }

    public boolean isExecutable() {
        if (this.file.isDirectory()) {
            return true;
        }
        if (this.file.getName().endsWith(".exe")) {
            return FileTypeUtils.guessWindowsExecutable(this.file);
        }
        if (this.file.getName().endsWith(".EXE")) {
            return FileTypeUtils.guessWindowsExecutable(this.file);
        }
        if (this.file.isFile()) {
            return FileTypeUtils.parseShebang(this.file) != null;
        }
        return false;
    }
}

