/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.b;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

import net.morilib.awk.AwkRuntimeException;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.misc.Endianness;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkValue;

/**
 * 関数b.writelonglの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/27
 */
public class BWritelongl extends AwkFunction {

	protected BWritelongl() {
		super("writelongl", null);
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		byte[] a = new byte[8];
		OutputStream ous;
		Endianness ed;

		try {
			if(args.size() < 1) {
				throw new AwkRuntimeException("Illegal argument");
			} else {
				ed = Endianness.LITTLE;
			}

			ous = o.openOutputStream(args.get(0).toString(ns));
			for(int i = 1; i < args.size(); i++) {
				ed.writeLong(
						a, 0, args.get(i).toInteger().longValue());
				ous.write(a);
			}
			return AwkInteger.TRUE;
		} catch (IOException e) {
			ns.getRoot().assign("ERRNO",
					AwkString.valueOf(e.getMessage()));
			return AwkInteger.FALSE;
		}
	}

}
