/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.stat;

import net.morilib.awk.builtin.AwkTernaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.stat.StatisticsUtils;
import net.morilib.awk.stat.dist.TDistribution;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

/**
 * 関数stat.t2testの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class T2Test extends AwkTernaryArgs {

	public T2Test() {
		super("t2test");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2, AwkValue a3) {
		TDistribution tdis;
		double[] obsv, ob2v;
		double t, max, min, mean, var1, mn2, var2, sv1, sv2, df;
		double significance = a3.toFloat();
		int num1, num2;

		if(significance < 0 || significance > 1) {
			throw new AwkStatisticsException("Invaild significance");
		}
		obsv = AwkStatUtils.toDoubleValues(a1);
		ob2v = AwkStatUtils.toDoubleValues(a2);
		num1 = obsv.length;
		num2 = ob2v.length;
		mean = StatisticsUtils.mean(obsv);
		var1 = StatisticsUtils.unbiasedVariance(obsv);
		mn2  = StatisticsUtils.mean(ob2v);
		var2 = StatisticsUtils.unbiasedVariance(ob2v);
		sv1  = var1 / num1;
		sv2  = var2 / num2;
		t    = (mean - mn2) / Math.sqrt(sv1 + sv2);
		df   = ((sv1 + sv2) * (sv1 + sv2) /
				(sv1 * sv1 / (num1 - 1) + sv2 * sv2 / (num2 - 1)));
		tdis = new TDistribution(df);

		min = tdis.invCdf(significance / 2);
		max = tdis.invCdf(1 - significance / 2);
		return (min < t && t < max) ? AwkInteger.ONE : AwkInteger.ZERO;
	}

}
