/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.bytes;

/**
 * Bool代数を表すインターフェースです。
 * 
 *
 * @author MORIGUCHI, Yuichiro 2010/08/28
 */
public interface BooleanElement<A extends BooleanElement<A>> {

	/**
	 * 結びを計算します。
	 * 
	 * @param x 値
	 * @return 結び
	 */
	public A join(A x);

	/**
	 * 交わりを計算します。
	 * 
	 * @param x 値
	 * @return 交わり
	 */
	public A meet(A x);

	/**
	 * 補集合を得ます。
	 * 
	 * @return 補集合
	 */
	public A complement();

	/**
	 * Bool代数の"0"のときtrueを得ます。
	 * 
	 * @return "0"のときtrue
	 */
	public boolean is0();

	/**
	 * Bool代数の"1"のときtrueを得ます。
	 * 
	 * @return "1"のときtrue
	 */
	public boolean is1();

}
