/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import net.morilib.sh.ShRootEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;

public class ShWindowsEnvironment extends ShRootEnvironment {

	ShWindowsEnvironment(ShFileSystem fs) {
		List<String> l = new ArrayList<String>();
		StringBuffer b = new StringBuffer();
		String s, d = "";
		String[] a;
		ShFile f;

		this.attrs = new HashMap<String, Attributes>();
		try {
			map = new HashMap<String, String>(System.getenv());
			if((s = map.get("Path")) != null) {
				map.remove("Path");
				map.put("PATH", s);
			}

			if((s = find("PATH")) != null) {
				a = s.split(";+");
				for(String t : a) {
					f = fs.getNativeFile(t);
					l.add(f.toString());
					b.append(d).append(f.toString());
					d = ":";
				}
				map.put("PATH", b.toString());
			}
			path = l;

			if(map.containsKey("HOMEDRIVE") &&
					map.containsKey("HOMEPATH")) {
				map.put("HOME", ShWindowsFileSystem.toJshFilename(
						map.get("HOMEDRIVE") + map.get("HOMEPATH")));
			}
		} catch(SecurityException e) {
			map = new HashMap<String, String>();
		}
	}

}
