/*
 * Decompiled with CFR 0.152.
 */
package net.excentrics.bandWidth;

import java.util.LinkedList;
import java.util.ListIterator;
import net.excentrics.bandWidth.AsymmetricalCallException;
import net.excentrics.bandWidth.SizeAndInterval;

class BandWidthController {
    private static final long defaultCycleInMils = 100L;
    private static final int speedCount = 70;
    private long cycle = 100L;
    private int bytePerCycle = 0;
    private double bandWidth = 0.0;
    private final LinkedList<Integer> sizeList;
    private final LinkedList<Long> timeList = new LinkedList();

    public BandWidthController() {
        this.sizeList = new LinkedList();
        this.setBytePerCycle();
    }

    private SizeAndInterval calculationSizeForWrite(int bufferSize) {
        if (this.bandWidth == 0.0) {
            return new SizeAndInterval(-1, 0L);
        }
        if (this.timeList.isEmpty()) {
            return new SizeAndInterval(this.bytePerCycle, this.cycle);
        }
        double currentBps = this.getCurrentBps();
        if (currentBps > this.bandWidth) {
            return new SizeAndInterval(0, this.cycle);
        }
        return new SizeAndInterval(this.bytePerCycle, this.cycle);
    }

    private double getCurrentBps() {
        int firstIndex = Math.max(this.sizeList.size() - 70, 0);
        ListIterator<Integer> li = this.sizeList.listIterator(firstIndex);
        int sizeInByte = 0;
        while (li.hasNext()) {
            Integer s = li.next();
            sizeInByte += s.intValue();
        }
        long startTime = this.timeList.get(firstIndex);
        long currentTime = System.currentTimeMillis();
        long intervalInMillis = currentTime - startTime;
        intervalInMillis = Math.max(1L, intervalInMillis);
        double intervalInSecond = (double)intervalInMillis / 1000.0;
        double currentBps = (double)(sizeInByte * 8) / intervalInSecond;
        return currentBps;
    }

    public SizeAndInterval preWrite(int bufferSize) {
        SizeAndInterval si = this.calculationSizeForWrite(bufferSize);
        this.timeList.add(System.currentTimeMillis());
        return si;
    }

    public void postWrite(int writtenSize) throws AsymmetricalCallException {
        this.sizeList.add(writtenSize);
        this.removeListItems();
        if (this.sizeList.size() != this.timeList.size()) {
            throw new AsymmetricalCallException("preWrite and postWrite called asymmetric.");
        }
    }

    private void removeListItems() {
        if (this.timeList.size() > 100) {
            int i = 0;
            while (i < 20) {
                this.timeList.remove();
                this.sizeList.remove();
                ++i;
            }
        }
    }

    private void setBytePerCycle() {
        this.bytePerCycle = (int)(this.bandWidth / 1000.0 * (double)this.cycle / 8.0);
    }

    public long getCycle() {
        return this.cycle;
    }

    public void setCycle(long cycle) {
        this.cycle = cycle;
        this.setBytePerCycle();
    }

    public double getBandWidth() {
        return this.bandWidth;
    }

    public void setBandWidth(double bandWidth) {
        this.bandWidth = bandWidth;
        this.sizeList.clear();
        this.timeList.clear();
        this.setBytePerCycle();
    }
}

