/*
 * Decompiled with CFR 0.152.
 */
package net.excentrics.bandWidth;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import net.excentrics.bandWidth.AsymmetricalCallException;
import net.excentrics.bandWidth.BandWidthController;
import net.excentrics.bandWidth.SizeAndInterval;

public class SocketChannelWriter {
    private final SocketChannel channel;
    private final BandWidthController c;

    public SocketChannelWriter(SocketChannel channel, double bandWidth) {
        this.channel = channel;
        this.c = new BandWidthController();
        this.c.setBandWidth(bandWidth);
    }

    public double getBandWidth() {
        return this.c.getBandWidth();
    }

    public void setBandWidth(double bandWidth) {
        this.c.setBandWidth(bandWidth);
    }

    public long write(ByteBuffer buffer) throws IOException {
        int writtenSize = 0;
        int size = buffer.remaining();
        SizeAndInterval si = this.c.preWrite(buffer.capacity());
        try {
            if (si.getSizeInByte() == 0) {
                this.c.postWrite(0);
            } else if (si.getSizeInByte() >= size || si.getSizeInByte() == -1) {
                writtenSize = this.channel.write(buffer);
                this.c.postWrite(writtenSize);
            } else {
                int limit = buffer.limit();
                buffer.limit(buffer.position() + si.getSizeInByte());
                writtenSize = this.channel.write(buffer);
                this.c.postWrite(writtenSize);
                buffer.limit(limit);
            }
        }
        catch (AsymmetricalCallException e) {
            throw new IOException(e);
        }
        return si.getIntervalInMils();
    }
}

