/*
 * Decompiled with CFR 0.152.
 */
package net.excentrics.bandWidth.sample;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import net.excentrics.bandWidth.SocketChannelWriter;

public class OneFileWebServer {
    public static void main(String[] args) {
        int bps = Integer.parseInt(args[0]) * 1024;
        try {
            ByteBuffer buf = ByteBuffer.allocate(13000);
            FileInputStream in = new FileInputStream(args[1]);
            FileChannel file = in.getChannel();
            ServerSocketChannel ssc = ServerSocketChannel.open();
            ssc.socket().bind(new InetSocketAddress(8080));
            SocketChannel sc = ssc.accept();
            sc.read(buf);
            buf.clear();
            String respHeader = "HTTP/1.0 200 OK\nContent-Type: image/jpeg\nConnection: Close\n\n";
            buf.put("HTTP/1.0 200 OK\nContent-Type: image/jpeg\nConnection: Close\n\n".getBytes("ascii"));
            buf.flip();
            sc.write(buf);
            buf.clear();
            SocketChannelWriter scw = new SocketChannelWriter(sc, bps);
            long sleeptime = 0L;
            boolean isEof = false;
            while (true) {
                if (!isEof && file.read(buf) == -1) {
                    isEof = true;
                }
                Thread.sleep(sleeptime);
                buf.flip();
                sleeptime = scw.write(buf);
                if (isEof && !buf.hasRemaining()) break;
                buf.compact();
            }
            ssc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

