#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <locale.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <glob.h>
#include <libgen.h>
#include <dirent.h>
#include <readline/readline.h>
#include <readline/history.h>
#include <oniguruma.h>

#include "config.h"

#ifdef __LINUX__
#include <sys/stat.h>
#include <linux/stat.h>
#include <linux/limits.h>
#endif
#if defined(__CYGWIN__) || defined(__CYGWIN7__)
#include <sys/stat.h>
#endif
#
#ifdef __LINUX__
#include <linux/limits.h>
#endif

#ifdef __LINUX__

#include <linux/limits.h>
#define __USE_POSIX
#define __USE_XOPEN_EXTENDED
#define __USE_POSIX199309
#define __USE_UNIX98
#include <signal.h>
#include <sys/wait.h>

#else

#include <signal.h>
#include <sys/stat.h>

#endif

char *
command_word_completion_function (const char* hint_text, int state);



#ifndef MINATO_STRING_H
#define MINATO_STRING_H

typedef struct
{
    char* mStr;
    int mLen;

    int mMallocLen;
} string_obj;

string_obj* string_new(char* str);
#define STRING_NEW(str) string_new(str)


void string_delete(string_obj* str);

#define string_length(o) ((string_obj*)o)->mLen
#define string_size(o) ((string_obj*)o)->mLen

char* string_c_str(string_obj* obj);

#define string_c_str(o) ((string_obj*)o)->mStr

void string_push_back(string_obj* self, char* key);
void string_push_back2(string_obj* self, char key);
void string_push_back3(string_obj* self, char* str, int n);
void string_put(string_obj* self, char* str);

void string_trunc(string_obj* self, int n);

void string_insert(string_obj* obj, int pos, char* str);
void string_erase(string_obj* obj, int pos, int len);

void string_toupper(string_obj* self);
void string_tolower(string_obj* self);

#endif

#include <string.h>
#include <ctype.h>
#include "config.h"

string_obj* string_new(char* str)
{
    string_obj* result;

    const int len = strlen(str);
    
    result = (string_obj*)malloc(sizeof(string_obj));
    
    result->mMallocLen = len + 1;
    result->mStr = (char*)malloc(sizeof(char)*result->mMallocLen);
    strcpy(result->mStr, str);
    
    result->mLen = len;

    return result;
}

void string_delete(string_obj* str)
{
    free(str->mStr);
    
    free(str);
}

void string_insert(string_obj* obj, int pos, char* str)
{
    char* new_str;
    char* tmp_str;
    const int str_len = strlen(str);

    if(pos <= obj->mLen) {
        if(obj->mLen+str_len+1 > obj->mMallocLen) {
            obj->mMallocLen = (obj->mLen + str_len + 1) * 2;
            new_str = (char*)malloc(obj->mMallocLen);

            memcpy(new_str, obj->mStr, pos);
            memcpy(new_str + pos, str, str_len);
            strcpy(new_str + pos + str_len, obj->mStr + pos);

            free(obj->mStr);

            obj->mStr = new_str;
            obj->mLen = strlen(new_str);
        }
        else {
            tmp_str = (char*)malloc(obj->mMallocLen);

            memcpy(tmp_str, obj->mStr, pos);
            memcpy(tmp_str + pos, str, str_len);
            strcpy(tmp_str + pos + str_len, obj->mStr + pos);

            strcpy(obj->mStr, tmp_str);
    
            free(tmp_str);
    
            obj->mLen = strlen(obj->mStr);
        }
    }
}

void string_push_back(string_obj* self, char* key)
{
    string_insert(self, string_length(self), key);
}

void string_push_back2(string_obj* self, char key)
{
    char tmp[2];
    tmp[0] = key;
    tmp[1] = 0;

    string_insert(self, string_length(self), tmp);
}

void string_push_back3(string_obj* self, char* str, int n)
{
    char* new_str;
    char* tmp_str;
    const int str_len = strlen(str);

    if(n > str_len) {
        n = str_len;
    }

    if(self->mLen+n+1 > self->mMallocLen) {
        self->mMallocLen = (self->mLen + n + 1) * 2;
        new_str = (char*)malloc(self->mMallocLen);

        int len = strlen(self->mStr);

        strcpy(new_str, self->mStr);
        memcpy(new_str + len, str, n);
        new_str[len + n] = 0;

        free(self->mStr);

        self->mStr = new_str;
        self->mLen = strlen(new_str);
    }
    else {
        int len = strlen(self->mStr);
        memcpy(self->mStr + len, str, n);
        (self->mStr)[len + n] = 0;

        self->mLen = strlen(self->mStr);
    }
}

void string_erase(string_obj* obj, int pos, int len)
{
    if(pos == 0 && len == obj->mLen) {
        string_put(obj, "");
    }
    else if(len > 0 && pos>=0 && pos<obj->mLen && pos+len <= obj->mLen) {
        memmove(obj->mStr + pos, obj->mStr+pos+len, obj->mLen-pos-len+1);

        obj->mLen-=len;
    }
}

void string_put(string_obj* self, char* str)
{
    const int len = strlen(str);
    if(len+1 < self->mMallocLen) {
        strcpy(self->mStr, str);
        self->mLen = strlen(str);
    }
    else {
        free(self->mStr);
        
        self->mMallocLen = len*2 + 1;
        self->mStr = (char*)malloc(sizeof(char)*self->mMallocLen);
        
        strcpy(self->mStr, str);
        self->mLen = strlen(str);
    }
}

void string_trunc(string_obj* self, int n)
{
    if(n < strlen(self->mStr)) {
        self->mStr[n] = 0;
        self->mLen = strlen(self->mStr);
    }
}

void string_tolower(string_obj* self)
{
    int i;
    for(i=0; i<self->mLen; i++) {
        self->mStr[i] = tolower(self->mStr[i]);
    }
}

void string_toupper(string_obj* self)
{
    int i;
    for(i=0; i<self->mLen; i++) {
        self->mStr[i] = toupper(self->mStr[i]);
    }
}







#ifndef MINATO__VECTOR_H
#define MINATO__VECTOR_H

#define BOOL int
#define TRUE 1
#define FALSE 0

typedef struct {
   void** mTable;
   int mTableSize;
   
   int mCount;
} vector_obj;

vector_obj* vector_new(int first_size);
#define VECTOR_NEW(size) vector_new(size)

void vector_delete(vector_obj* self);
vector_obj* vector_clone(vector_obj* v);

#define vector_item(o, i) ((vector_obj*)o)->mTable[i]

#define vector_size(o) ((vector_obj*)o)->mCount

int vector_index(vector_obj* self, void* item);

void vector_exchange(vector_obj* self, int n, void* item);
void vector_add(vector_obj* self, void* item);
void vector_insert(vector_obj* self, int n, void* item);
void* vector_erase(vector_obj* self, int n);
void* vector_pop_back(vector_obj* self);
void* vector_pop_front(vector_obj* self);
void vector_clear(vector_obj* self);

typedef BOOL (*sort_if)(void* left, void* right);
void vector_sort(vector_obj* self, sort_if fun);



#endif

vector_obj* vector_new(int first_size)
{
   vector_obj* self = (vector_obj*)malloc(sizeof(vector_obj));

   self->mTable = (void**)malloc(sizeof(void*) * first_size);
   self->mTableSize = first_size;
   self->mCount = 0;

   return self;
}

void vector_delete(vector_obj* self)
{
   free(self->mTable);
   free(self);
}

vector_obj* vector_clone(vector_obj* v)
{
    int i;
    vector_obj* result;

    result = VECTOR_NEW(vector_size(v)+1);
    for(i = 0; i<vector_size(v); i++) {
        vector_add(result, vector_item(v, i));
    }

    return result;
}


void vector_exchange(vector_obj* self, int n, void* item)
{
   self->mTable[n] = item;
}

void vector_add(vector_obj* self, void* item)
{
   if(self->mCount == self->mTableSize) {
      self->mTableSize = self->mTableSize * 2;

      self->mTable = (void**)realloc(self->mTable
                                , sizeof(void*)*self->mTableSize);
   }

   self->mTable[self->mCount] = item;
   self->mCount++;
}

void vector_insert(vector_obj* self, int n, void* item)
{
   if(self->mCount == self->mTableSize) {
      self->mTableSize = self->mTableSize * 2;

      self->mTable = (void**)realloc(self->mTable
                              , sizeof(void*)*self->mTableSize);
   }

   memmove(self->mTable +n +1, self->mTable +n
                           , sizeof(void*)*(self->mCount - n));
   
   self->mTable[n] = item;
   self->mCount++;
}

int vector_index(vector_obj* self, void* item)
{
    int i;
    for(i=0; i<self->mCount; i++) {
        if(self->mTable[i] == item) {
            return i;
        }
    }

    return -1;
}

void* vector_erase(vector_obj* self, int n)
{
    void* item = NULL;

    if(n>=0 && n<self->mCount) {
        item = self->mTable[n];
        memmove(self->mTable + n, self->mTable + n + 1, sizeof(void*)*(self->mCount -n-1));

        self->mCount--;
    }

    return item;
}

void* vector_pop_back(vector_obj* self)
{
    return vector_erase(self, self->mCount-1);
}

void* vector_pop_front(vector_obj* self)
{
    return vector_erase(self, 0);
}

static void quick_sort(vector_obj* self, int left, int right, sort_if fun)
{
   int i;
   int j;
   void* center_item;

if(left < right) {
center_item = self->mTable[(left+right) / 2];

i = left;
j = right;

do { 
while(self->mTable[i]!=center_item
                     && fun(self->mTable[i], center_item))
         {
i++;
}
         
while(center_item!=self->mTable[j]
                     && fun(center_item, self->mTable[j]))
         {
j--;
}

if(i <= j) {
void* tmp = self->mTable[i]; 
self->mTable[i] = self->mTable[j];
self->mTable[j] = tmp;

i++;
j--;
}
} while(i <= j);

quick_sort(self, left, j, fun);
quick_sort(self, i, right, fun);
}
}

void vector_sort(vector_obj* self, sort_if fun)
{
    quick_sort(self, 0, self->mCount-1, fun);
}

void vector_clear(vector_obj* self)
{
    self->mCount = 0;
}









static BOOL is_quoted_char(char c)
{
    return c==' ' || c=='*' || c=='>' || c=='&' || c=='~' || c=='#' || c =='$'
    || c=='(' || c==')' || c=='`' 
    || c=='\\' || c=='|' || c=='[' || c==']' || c=='{' || c=='}' || c==';'
    || c=='\'' || c=='"' || c=='<' || c=='>' || c=='?' || c=='\n' || c=='\t'
    || c=='\r' || c==':' || c=='!' || c=='@'  || c=='=';
}

void bash_get_quoted_fname(char* fname, string_obj* quoted_fname)
{
    char* p = fname;
    while(*p) {
        if(*p == '\n') {
            string_push_back(quoted_fname, "\\n");
            p++;
        }
        else if(*p == '\r') {
            string_push_back(quoted_fname, "\\r");
            p++;
        }
        else if(is_quoted_char(*p)) {
            string_push_back2(quoted_fname, '\\');
            string_push_back2(quoted_fname, *p++);
        }
        else {
            string_push_back2(quoted_fname, *p++);
        }
    }
}

int is_all_ascii(char* buf)
{
    char* p = buf;
    while(*p) {
        if(*p < ' ' || *p > '~') {
            return FALSE;
        }
        p++;
    }

    return TRUE;
}

void parentname(char* result, char* path)
{
    char* p;

    if(*path == 0) {
        strcpy(result, "");
        return;
    }
    
    if(strcmp(path, "/") == 0) {
        strcpy(result, "/");
        return;
    }

    for(p=path + strlen(path)-2; p != path-1; p--) {
        if(*p == '/' ) {
            memcpy(result, path, p-path);
            result[p-path] = '/';
            result[p-path+1] = 0;
            
            return;
        }
    }

    strcpy(result, "");
}





vector_obj* gEnvirons = NULL;
static vector_obj* files = NULL;




//////////////////////////////////////////////////////////////////////
// readline
//////////////////////////////////////////////////////////////////////
static BOOL name_sort(void* left, void* right)
{
    string_obj* l = (string_obj*)left;
    string_obj* r = (string_obj*) right;

    char* lfname = string_c_str(l);
    char* rfname = string_c_str(r);

    if(strcmp(lfname, ".") == 0) return TRUE;
    if(strcmp(lfname, "..") == 0) {
        if(strcmp(rfname, ".") == 0) return FALSE;

        return TRUE;          
    }
    if(strcmp(rfname, ".") == 0) return FALSE;
    if(strcmp(rfname, "..") == 0) return FALSE;

    return strcasecmp(lfname, rfname) < 0;
}

#if defined(HAVE_MIGEMO_H)
#include <migemo.h>

migemo* gMigemo;
static regex_t* gReg;

void migemo_init()
{
    char buf[PATH_MAX];
    char migemodir[PATH_MAX];
    gMigemo = migemo_open(NULL);

    sprintf(migemodir,"%s", SYSTEM_MIGEMODIR);

    sprintf(buf, "%s/utf-8/migemo-dict", migemodir);
    if(migemo_load(gMigemo, MIGEMO_DICTID_MIGEMO, buf) == MIGEMO_DICTID_INVALID) {
        fprintf(stderr, "%s is not found\n", buf);
        exit(1);
    }
    sprintf(buf, "%s/utf-8/roma2hira.dat", migemodir);
    if(migemo_load(gMigemo, MIGEMO_DICTID_ROMA2HIRA, buf) == MIGEMO_DICTID_INVALID) {
        fprintf(stderr, "%s is not found\n", buf);
        exit(1);
    }
    sprintf(buf, "%s/utf-8/hira2kata.dat", migemodir);
    if(migemo_load(gMigemo, MIGEMO_DICTID_HIRA2KATA, buf) == MIGEMO_DICTID_INVALID) {
        fprintf(stderr, "%s is not found\n", buf);
        exit(1);
    }
    sprintf(buf, "%s/utf-8/han2zen.dat", migemodir);
    if(migemo_load(gMigemo, MIGEMO_DICTID_HAN2ZEN, buf) == MIGEMO_DICTID_INVALID) {
        fprintf(stderr, "%s is not found\n", buf);
        exit(1);
    }
}

void migemo_final()
{
    onig_end();
    migemo_close(gMigemo);
    if(gReg) onig_free(gReg);
    gReg = NULL;
}

/// ƬƱʸ󤬤뤫ɤĴ٤롣
/// 0 == Ʊʸ0ʸ
/// 1 == Ʊʸ1ʸ
/// ʸmbsȤƤߤ
int str_headsame(char* str1, char* str2)
{
    char* p1 = str1;
    char* p2 = str2;

    while(*p1 && *p2 && *p1 == *p2) {
        p1++;
        p2++;
    }

    return p1 - str1;
}

void bash_get_quoted_fname_readline_ver(char* file, string_obj* ret)
{
    string_obj* tmp = STRING_NEW("");
    bash_get_quoted_fname(file, tmp);

    /// ~ΥȤ ///
    char* p = string_c_str(tmp);
    
    while(*p) {
        if(*p == '\\' && *(p+1) == '~') {
            p++;
            string_push_back2(ret, *p++);
        }
        else {
            string_push_back2(ret, *p++);
        }
    }

    string_delete(tmp);
}


char* readline_file_completion_migemo_match(char* editing_dir, char* text, char* file)
{
//printf("editing_dir (%s) text (%s) file (%s)\n", editing_dir, text, file);
    /// textfileƱȤޤǤӤʤ ///
    int same_point = str_headsame(text+ strlen(editing_dir), file);

    OnigUChar * p;
    if(same_point == 0) {
        p = migemo_query(gMigemo, text + strlen(editing_dir));
    }
    /// text¦fileʬʤȽꤹޤǤ̵ޥå ///
    else if(same_point == strlen(text + strlen(editing_dir))) {
        char tmp[PATH_MAX];
        strcpy(tmp, editing_dir);
        strcat(tmp, file);
        string_obj* tmp2 = STRING_NEW("");
        bash_get_quoted_fname_readline_ver(tmp, tmp2);
        char* ret = strdup(string_c_str(tmp2));
        string_delete(tmp2);

        return ret;
    }
    else {
        p = migemo_query(gMigemo, text + strlen(editing_dir)+same_point);
    }


    if(p == NULL) {
        return NULL;
    }

    static regex_t* reg;

    int r;
    OnigErrorInfo err_info;

    char* p2 = malloc(strlen(p)*2);

    char* _p = p;
    char* _p2 = p2;

    while(*_p) {
        if(*_p == '+') {
            *_p2++ = '\\';
            *_p2++ = *_p++;
        }
        else {
            *_p2++ = *_p++;
        }
    }
    *_p2 = 0;

    r = onig_new(&reg, p2, p2 + strlen((char*)p2), ONIG_OPTION_DEFAULT, ONIG_ENCODING_UTF8, ONIG_SYNTAX_DEFAULT,  &err_info);

    free(p2);

    migemo_release(gMigemo, (unsigned char*) p);

    if(r != ONIG_NORMAL) {
        return NULL;
    }

    OnigRegion* region = onig_region_new();
    
    OnigUChar* file2;
    if(same_point == 0) {
        file2 = (OnigUChar*)file;
    }
    else {
        file2 = (OnigUChar*)file + same_point;
    }

    int r2 = onig_search(reg, file2, file2 + strlen((char*)file2), file2, file2 + strlen((char*)file2), region, ONIG_OPTION_NONE);

    onig_region_free(region, 1);

    onig_free(reg);

    if(r2 == 0) {
        char tmp[PATH_MAX];
        strcpy(tmp, editing_dir);
        strcat(tmp, file);
        string_obj* tmp2 = STRING_NEW("");
        bash_get_quoted_fname_readline_ver(tmp, tmp2);
        char* ret = strdup(string_c_str(tmp2));
        string_delete(tmp2);

        return ret;
    }

//printf("E");
    return NULL;
}

char* migemo_readline_file_completion(const char* text, int rstat)
{
    /// Ȥ ///
    char* text2 = malloc(strlen(text) +1);
    char* _p = (char*)text;
    char* _p2 = text2;

    while(*_p) {
        if(*_p == '\\') {
            _p++;
        }
        else {
            *_p2++ = *_p++;
        }
    }
    *_p2 = 0;

    static int index, wordlen, wordlen_editting_file;
    static char editing_dir[PATH_MAX];
    static char editing_dir2[PATH_MAX];
    static char editing_file[PATH_MAX];
    static int wordlen_editing_file;

    ///  ///
    if(rstat == 0) {
        wordlen = strlen(text2);
        index = 0;

        /// ǥ쥯ȥΥѡȤȥեΥѡȤʬ ///
        if(strcmp(text2, "") == 0) {
            strcpy(editing_dir, "");
            strcpy(editing_file, "");
        }
        else if(strstr(text2, "/") == NULL) {
            strcpy(editing_dir, "");
            strcpy(editing_file, text2);
        }
        else if(text2[strlen(text2) -1] == '/') {
            strcpy(editing_dir, (char*)text2);
            strcpy(editing_file, "");
        }
        else {
            parentname(editing_dir, (char*)text2);
            char tmp[PATH_MAX];   // basenameΰľϤȤޤ
            strcpy(tmp, (char*)text2);
            strcpy(editing_file, basename(tmp));
        }

        wordlen_editing_file = strlen(editing_file);

        /// ϤޤäƤ ///
        if(editing_dir[0] == '~') {
            char* p = editing_dir;
            p++;

            strcpy(editing_dir2, getenv("HOME"));
            strcat(editing_dir2, p);
        }
        else {
            strcpy(editing_dir2, editing_dir);
        }

        /// 䴰 ///
        if(files == NULL) {
            files = VECTOR_NEW(50);
        }
        else {
            int i;
            for(i=0; i<vector_size(files); i++) {
                string_delete(vector_item(files, i));
            }
            vector_clear(files);
        }

        /// 䴰ǥ쥯ȥ꤫ɤ߹ ///
        if(strcmp(editing_dir2, "") != 0) {
            DIR* dir = opendir(editing_dir2);

            if(dir) {
                struct dirent* entry;
                while(entry = readdir(dir)) {
                    if(strcmp(entry->d_name, ".") != 0
                            && strcmp(entry->d_name, "..") != 0)
                    {
                        char buf[PATH_MAX];

                        struct stat _stat;
                        strcpy(buf, editing_dir2);
                        strcat(buf, entry->d_name);
                        stat(buf, &_stat);

                        strcpy(buf, entry->d_name);
                        if(S_ISDIR(_stat.st_mode)) {
                            strcat(buf, "/");
                        }

                        vector_add(files, STRING_NEW(buf));
                    }
                }

                closedir(dir);

                vector_sort(files,name_sort);
            }
        }
        else {
            DIR* dir = opendir(".");

            if(dir) {
                struct dirent* entry;
                while(entry = readdir(dir)) {
                    if(strcmp(entry->d_name, ".") != 0
                            && strcmp(entry->d_name, "..") != 0)
                    {
                        char buf[PATH_MAX];

                        struct stat _stat;
                        strcpy(buf, "./");
                        strcat(buf, entry->d_name);
                        stat(buf, &_stat);

                        strcpy(buf, entry->d_name);
                        if(S_ISDIR(_stat.st_mode)) {
                            strcat(buf, "/");
                        }
                        vector_add(files, STRING_NEW(buf));
                    }
                }

                closedir(dir);

                vector_sort(files, name_sort);
            }
        }
    }

    while(index < vector_size(files)) {
        char* file = string_c_str(vector_item(files, index));
        index++;

        /// ե̾Ϥʤ䴰ȽꤷʤƤƥޥå ///
        if(strcmp(editing_file, "") == 0)
        {
            char path[PATH_MAX];
            strcpy(path, editing_dir2);
            strcat(path, file);

            string_obj* tmp2 = STRING_NEW("");
            bash_get_quoted_fname_readline_ver(path, tmp2);
            char* ret = strdup(string_c_str(tmp2));
            string_delete(tmp2);

            struct stat stat_;
            if(stat(path, &stat_) == 0) {
                if(S_ISDIR(stat_.st_mode)) {
                    rl_completion_append_character= 0;
                }
                else {
                    rl_completion_append_character= ' ';
                }
            }
            else {
                rl_completion_append_character= ' ';
            }

            free(text2);
            if(ret) return ret;
        }

        /// ʸƱΤ䴰 ///
        else if(is_all_ascii((char*)editing_file) && is_all_ascii(file)) {
            if(!strncmp(editing_file, file, wordlen_editing_file)) {
                char path[PATH_MAX];
                strcpy(path, editing_dir2);
                strcat(path, file);

                string_obj* tmp2 = STRING_NEW("");
                bash_get_quoted_fname(path, tmp2);
                char* ret = strdup(string_c_str(tmp2));
                string_delete(tmp2);

                struct stat stat_;
                if(stat(path, &stat_) == 0) {
                    if(S_ISDIR(stat_.st_mode)) {
                        rl_completion_append_character= 0;
                    }
                    else {
                        rl_completion_append_character= ' ';
                    }
                }
                else {
                    rl_completion_append_character= ' ';
                }

                free(text2);

                if(ret) return ret;
            }
        }

        /// migemo 䴰 ///
        else {
            char* ret = readline_file_completion_migemo_match(editing_dir, (char*)text2 , file);
            if(ret) {
                struct stat stat_;
                char path[PATH_MAX];
                strcpy(path, editing_dir2);
                strcat(path, file);
                if(stat(path, &stat_) == 0) {
                    if(S_ISDIR(stat_.st_mode)) {
                        rl_completion_append_character= 0;
                    }
                    else {
                        rl_completion_append_character= ' ';
                    }
                }
                else {
                    rl_completion_append_character= ' ';
                }

                free(text2);
                return ret;
            }
        }
    }

    free(text2);
    return NULL;
}
#endif

char* readline_env_completion(const char* text, int stat)
{
    static int index, wordlen;

    if(stat == 0) {
        wordlen = strlen(text);
        index = 0;
    }

    if(gEnvirons) {
        while(index < vector_size(gEnvirons)) {
            char* env = string_c_str(vector_item(gEnvirons, index));
            index++;

            if(!strncmp(text, env, wordlen)) {
                return strdup(env);
            }
        }
    }

    return NULL;
}

char** readline_on_complete(const char* text, int start, int end)
{
//printf("\n\ntext (%s) start %d end %d rl_line_buffer %s\n\n", text, start, end, rl_line_buffer);
    
    BOOL program = TRUE;
    BOOL env = FALSE;

    char* p = rl_line_buffer;

    while(*p == ' ' || *p == '\t' || *p == '\n') {
        p++;
    }

    BOOL squote = FALSE;
    BOOL dquote = FALSE;
    while(p < rl_line_buffer + end) {
        // 
        if(*p == '\\') {
            p+=2;
            env = FALSE;
        }

        // 󥰥륯
        else if(!dquote && *p == '\'') {
            p++;
            squote = !squote;
            env = FALSE;
        }
        // ֥륯
        else if(!squote && *p == '"') {
            p++;
            dquote = !dquote;
            env = FALSE;
        }
        // Ķѿ $()
        else if(!squote && *p == '$' && *(p+1) == '(') {
            p+=2;

            program = TRUE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            env = FALSE;
        }
        else if(!dquote && !squote && *p == ')') {
            p++;
            program = FALSE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            env = FALSE;
        }

        // Ķѿ $
        else if(!squote && *p == '$') {
            p+=2;
            env = TRUE;
        }
        /// 󥰥륯ȡ֥륯 ///
        else if(squote || dquote) {
            p++;
        }
        ///  ///
        else if(*p == '*' || *p == '?' || *p =='[' && (*(p+1) != ' ' && *(p+1) != '\t' && *(p+1) == '\n')) 
        {
            p++;
            env = FALSE;
        }
        else if(*p == '<' && program) {
            p++;

            program = FALSE;
            env = FALSE;
        }
        /// ñζڤ /////////////////////////////////////////////////
    
        ///  ///
        else if(*p == ' ' || *p == '\t') {
            while(*p == ' ' || *p == '\t') {
                p++;
            }

            if(program) program = FALSE;
            env = FALSE;
        }
        
        /// ޥɤζڤ ///////////////////////////////////////////
        
        /// ѥ ///
        else if(*p == '|' && *(p+1) != '|') {
            p++;

            program = TRUE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            env = FALSE;
        }
        
        /// ʸ(statment)ζڤ ///////////////////////////////////
    
        /// ɥ ///
        else if(*p == '&' && *(p+1) == '&') {
            p+=2;

            program = TRUE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            env = FALSE;
        }
        ///  ///
        else if(*p == '|' && *(p+1) == '|') {
            p+=2;

            program = TRUE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            env = FALSE;
        }
        /// Хå饦 ///
        else if(*p == '&' && *(p+1) != '&') {
            p++;

            program = TRUE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            env = FALSE;
        }
        /// ߥ ///
        else if(*p == ';') {
            p++;

            program = TRUE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            env = FALSE;
        }
        ///  ///
        else if(*p == '\n') {
            p++;

            program = TRUE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            env = FALSE;
        }
        ///  ///
        else if(*p == '#') {
            p++;

            while(*p) {
                if(*p == '\n') {
                    p++;
                    program = TRUE;
                    break;
                }
                else {
                    p++;
                }
            }
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            env = FALSE;
        }
        /// λ ///
        else if(*p == 0) {
            break;
        }
        
        /// ʸ ////////////////////////////////////////////////////////

        /// ֥ ///
        else if(*p == '(') {
            p++;
            program = TRUE;
            env = FALSE;
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
        }
        else {
            p++;
        }
    }

    if(env) {
        rl_completion_append_character= ' ';
        return rl_completion_matches(text, readline_env_completion);
    }
    else if(program) {
        rl_completion_append_character= ' ';
        return rl_completion_matches(text, command_word_completion_function);
    }
#if defined(HAVE_MIGEMO_H)
    else {
        return rl_completion_matches(text, migemo_readline_file_completion);
    }

#endif

    return NULL;
}







////////////////////////////////////////////////////////////
// lftp, bashꥳԡ
////////////////////////////////////////////////////////////
static int shell_cmd;
static int quote_glob;
static int inhibit_tilde;

/* mbschr.c - strchr(3) that handles multibyte characters. */

/* Copyright (C) 2002 Free Software Foundation, Inc.

   This file is part of GNU Bash, the Bourne Again SHell.

   Bash is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   Bash is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Bash.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifdef HAVE_STDLIB_H
#  include <stdlib.h>
#endif

#undef mbschr

/* In some locales, the non-first byte of some multibyte characters have
   the same value as some ascii character.  Faced with these strings, a
   legacy strchr() might return the wrong value. */

char *
#if defined (PROTOTYPES)
mbschr (const char *s, int c)
#else
mbschr (s, c)
     const char *s;
     int c;
#endif
{
#if HANDLE_MULTIBYTE
  char *pos;
  mbstate_t state;
  size_t strlength, mblength;

  /* The locale encodings with said weird property are BIG5, BIG5-HKSCS,
     GBK, GB18030, SHIFT_JIS, and JOHAB.  They exhibit the problem only
     when c >= 0x30.  We can therefore use the faster bytewise search if
     c <= 0x30. */
  if ((unsigned char)c >= '0' && MB_CUR_MAX > 1)
    {
      pos = (char *)s;
      memset (&state, '\0', sizeof(mbstate_t));
      strlength = strlen (s);

      while (strlength > 0)
	{
	  mblength = mbrlen (pos, strlength, &state);
	  if (mblength == (size_t)-2 || mblength == (size_t)-1 || mblength == (size_t)0)
	    mblength = 1;

	  if (mblength == 1 && c == (unsigned char)*pos)
	    return pos;

	  strlength -= mblength;
	  pos += mblength;
	}

      return ((char *)NULL);
    }
  else
#endif
  return (strchr (s, c));
}


static char *
quote_word_break_chars (text)
     char *text;
{
  char *ret, *r, *s;
  int l;

  l = strlen (text);
  ret = (char *)malloc ((2 * l) + 1);
  for (s = text, r = ret; *s; s++)
    {
      /* Pass backslash-quoted characters through, including the backslash. */
      if (*s == '\\')
	{
	  *r++ = '\\';
	  *r++ = *++s;
	  if (*s == '\0')
	    break;
	  continue;
	}
      //OK, we have an unquoted character.  Check its presence in rl_completer_word_break_characters. 

      if (mbschr (rl_completer_word_break_characters, *s)) *r++ = '\\';
      // XXX -- check for standalone tildes here and backslash-quote them
      //if (s == text && *s == '~' && file_exists (text)) *r++ = '\\';
      *r++ = *s;

    }
  *r = '\0';
  return ret;
}

#define COMPLETE_DQUOTE  1
#define COMPLETE_SQUOTE  2
#define COMPLETE_BSQUOTE 3

static int completion_quoting_style = COMPLETE_BSQUOTE;


/* Quote STRING using double quotes.  Return a new string. */
/*
char *
sh_double_quote (string)
     char *string;
{
  register unsigned char c;
  char *result, *r, *s;

  result = (char *)malloc (3 + (2 * strlen (string)));
  r = result;
  *r++ = '"';

  for (s = string; s && (c = *s); s++)
    {
      ///Backslash-newline disappears within double quotes, so don't add one. 
      if ((sh_syntaxtab[c] & CBSDQUOTE) && c != '\n')
	*r++ = '\\';
      else if (c == CTLESC || c == CTLNUL)
	*r++ = CTLESC;   /// could be '\\'? 

      *r++ = c;
    }

  *r++ = '"';
  *r = '\0';

  return (result);
}
*/


/* Remove backslashes that are quoting characters that are special between
   double quotes.  Return a new string.  XXX - should this handle CTLESC
   and CTLNUL? */
/*
char *
sh_un_double_quote (string)
     char *string;
{
  register int c, pass_next;
  char *result, *r, *s;

  r = result = (char *)malloc (strlen (string) + 1);

  for (pass_next = 0, s = string; s && (c = *s); s++)
    {
      if (pass_next)
	{
	  *r++ = c;
	  pass_next = 0;
	  continue;
	}
      if (c == '\\' && (sh_syntaxtab[(unsigned char) s[1]] & CBSDQUOTE))
	{
	  pass_next = 1;
	  continue;
	}
      *r++ = c;
    }

  *r = '\0';
  return result;
}
*/

/* Filename quoting for completion. */
/* A function to strip quotes that are not protected by backquotes.  It
   allows single quotes to appear within double quotes, and vice versa.
   It should be smarter. */
static char *
bash_dequote_filename (const char *text, int quote_char)
{
  char *ret;
  const char *p;
  char *r;
  int l, quoted;

  l = strlen (text);
  ret = (char*)malloc (l + 1);
  for (quoted = quote_char, p = text, r = ret; p && *p; p++)
    {
      /* Allow backslash-quoted characters to pass through unscathed. */
      if (*p == '\\')
	{
	  *r++ = *++p;
	  if (*p == '\0')
	    break;
	  continue;
	}
      /* Close quote. */
      if (quoted && *p == quoted)
        {
          quoted = 0;
          continue;
        }
      /* Open quote. */
      if (quoted == 0 && (*p == '\'' || *p == '"'))
        {
          quoted = *p;
          continue;
        }
      *r++ = *p;
    }
  *r = '\0';
  return ret;
}




static char* kitutuki_quote_filename(char* str, int rtype, char* qcp)
{
    char* rtext = quote_word_break_chars (str);

    return strdup(str);
    //rtext;
}

int kitutuki_quoted_p(char* string, int index)
{
    if(strlen(string) > 0 && string[strlen(string)-1] == '\\') {
        return 0;
    }
    else {
        return 1;
    }
}
static int skip_quoted(const char *s, int i, char q)
{
   while(s[i] && s[i]!=q)
   {
      if(s[i]=='\\' && s[i+1])
	 i++;
      i++;
   }
   if(s[i])
      i++;
   return i;
}


int lftp_char_is_quoted(const char *string,int eindex)
{
  int i, pass_next;

  for (i = pass_next = 0; i <= eindex; i++)
    {
      if (pass_next)
        {
          pass_next = 0;
          if (i >= eindex)
            return 1;
          continue;
        }
      else if (string[i] == '"' || string[i] == '\'')
        {
	  char quote = string[i];
          i = skip_quoted (string, ++i, quote);
          if (i > eindex)
            return 1;
          i--;  /* the skip functions increment past the closing quote. */
        }
      else if (string[i] == '\\')
        {
          pass_next = 1;
          continue;
        }
    }
  return (0);
}










/* Quote STRING using double quotes.  Return a new string. */
static char *
double_quote (char *string)
{
  register int c;
  char *result, *r, *s;

  result = (char *)malloc (3 + (2 * strlen (string)));
  r = result;
  *r++ = '"';

  for (s = string; s && (c = *s); s++)
    {
      switch (c)
        {
	case '$':
	case '`':
	  if(!shell_cmd)
	     goto def;
	case '"':
	case '\\':
	  *r++ = '\\';
	default: def:
	  *r++ = c;
	  break;
        }
    }

  *r++ = '"';
  *r = '\0';

  return (result);
}


/* Return a new string which is the single-quoted version of STRING.
   Used by alias and trap, among others. */
static char *
single_quote (char *string)
{
  register int c;
  char *result, *r, *s;

  result = (char *)malloc (3 + (4 * strlen (string)));
  r = result;
  *r++ = '\'';

  for (s = string; s && (c = *s); s++)
    {
      *r++ = c;

      if (c == '\'')
	{
	  *r++ = '\\';	/* insert escaped single quote */
	  *r++ = '\'';
	  *r++ = '\'';	/* start new quoted string */
	}
    }

  *r++ = '\'';
  *r = '\0';

  return (result);
}

/* Quote special characters in STRING using backslashes.  Return a new
   string. */
static char *
backslash_quote (char *string)
{
  int c;
  char *result, *r, *s;

  result = (char*)malloc (2 * strlen (string) + 1);

  for (r = result, s = string; s && (c = *s); s++)
    {
      switch (c)
	{
 	case '(': case ')':
 	case '{': case '}':			/* reserved words */
 	case '^':
 	case '$': case '`':			/* expansion chars */
	  if(!shell_cmd)
	    goto def;
 	case '*': case '[': case '?': case ']':	/* globbing chars */
	  if(!shell_cmd && !quote_glob)
	    goto def;
	case ' ': case '\t': case '\n':		/* IFS white space */
	case '"': case '\'': case '\\':		/* quoting chars */
	case '|': case '&': case ';':		/* shell metacharacters */
	case '<': case '>': case '!':
	  *r++ = '\\';
	  *r++ = c;
	  break;
/*
	case '~':				// tilde expansion 
	  if (s == string && inhibit_tilde)
	    *r++ = '.', *r++ = '/';
	  goto def;
*/
	case '#':				/* comment char */
	  if(!shell_cmd)
	    goto def;
	  if (s == string)
	    *r++ = '\\';
	  /* FALLTHROUGH */
	default: def:
	  *r++ = c;
	  break;
	}
    }

  *r = '\0';
  return (result);
}






/* Quote a filename using double quotes, single quotes, or backslashes
   depending on the value of completion_quoting_style.  If we're
   completing using backslashes, we need to quote some additional
   characters (those that readline treats as word breaks), so we call
   quote_word_break_chars on the result. */
static char *
bash_quote_filename (char *s, int rtype, char *qcp)
{
  char *rtext, *mtext, *ret;
  int rlen, cs;

  rtext = (char *)NULL;

  /* If RTYPE == MULT_MATCH, it means that there is
     more than one match.  In this case, we do not add
     the closing quote or attempt to perform tilde
     expansion.  If RTYPE == SINGLE_MATCH, we try
     to perform tilde expansion, because single and double
     quotes inhibit tilde expansion by the shell. */

  mtext = s;
#if 0
  if (mtext[0] == '~' && rtype == SINGLE_MATCH)
    mtext = bash_tilde_expand (s);
#endif

  cs = completion_quoting_style;
  /* Might need to modify the default completion style based on *qcp,
     since it's set to any user-provided opening quote. */
  if (*qcp == '"')
    cs = COMPLETE_DQUOTE;
  else if (*qcp == '\'')
    cs = COMPLETE_SQUOTE;
/*
#if defined (BANG_HISTORY)
  else if (*qcp == '\0' && history_expansion && cs == COMPLETE_DQUOTE &&
	   history_expansion_inhibited == 0 && strchr (mtext, '!'))
    cs = COMPLETE_BSQUOTE;

  if (*qcp == '"' && history_expansion && cs == COMPLETE_DQUOTE &&
        history_expansion_inhibited == 0 && strchr (mtext, '!'))
    {
      cs = COMPLETE_BSQUOTE;
      *qcp = '\0';
    }
#endif
*/

  switch (cs)
    {
    case COMPLETE_DQUOTE:
      rtext = double_quote (mtext);
      break;
    case COMPLETE_SQUOTE:
      rtext = single_quote (mtext);
      break;
    case COMPLETE_BSQUOTE:
      rtext = backslash_quote (mtext);
      break;
    }

  if (mtext != s)
    free (mtext);

  /* We may need to quote additional characters: those that readline treats
     as word breaks that are not quoted by backslash_quote. */
  if (rtext && cs == COMPLETE_BSQUOTE)
    {
      mtext = quote_word_break_chars (rtext);
      free (rtext);
      rtext = mtext;
    }

  /* Leave the opening quote intact.  The readline completion code takes
     care of avoiding doubled opening quotes. */
  rlen = strlen (rtext);
  ret = (char*)malloc (rlen + 1);
  strcpy (ret, rtext);

  /* If there are multiple matches, cut off the closing quote. */
  if (rtype == MULT_MATCH && cs != COMPLETE_BSQUOTE)
    ret[rlen - 1] = '\0';
  free (rtext);
  return ret;
}











void migemo_readline_init()
{
    //rl_attempted_completion_function = readline_on_complete;
/*
    rl_completer_quote_characters = "\"'";
    rl_completer_word_break_characters = " \t\n\"'|{}&;()<>=";
    rl_filename_quote_characters = " \\\t\n\"|$%*?[]<>:{}&;#()'";
    rl_completion_append_character= ' ';
    rl_char_is_quoted_p = (rl_linebuf_func_t*)lftp_char_is_quoted;
    rl_filename_quoting_function = bash_quote_filename;
    rl_filename_dequoting_function = (rl_dequote_func_t*)bash_dequote_filename;
*/

#if defined(HAVE_MIGEMO_H)
    migemo_init();
#endif

#if !HAVE_DECL_ENVIRON
    extern char **environ;

    gEnvirons = VECTOR_NEW(5);
    char** p;
    for(p = environ; *p; p++) {
        char env_name[256];

        char* p2 = env_name;
        char* p3 = *p;

        *p2++ = '$';
        while(*p3 != '=') {
            *p2++ = *p3++;
        }

        char* env = getenv(*p);
        struct stat estat;
        if(stat(env, &estat) >= 0) {
            if(S_ISDIR(estat.st_mode)) {
                *p2++ = '/';
            }
        }
        *p2 = 0;

        vector_add(gEnvirons, STRING_NEW(env_name));
    }

    vector_sort(gEnvirons, name_sort);
#endif
}

void migemo_readline_final()
{
    if(gEnvirons) {
        int i;
        for(i=0; i<vector_size(gEnvirons); i++) {
            string_delete(vector_item(gEnvirons, i));
        }
        vector_delete(gEnvirons);
    }
    if(files) {
        int i;
        for(i=0; i<vector_size(files); i++) {
            string_delete(vector_item(files, i));
        }
        vector_delete(files);
    }
#if defined(HAVE_MIGEMO_H)
    migemo_final();
#endif
}
