unit Unit2;

interface

uses
  SysUtils, Classes, HTTPApp, StrUtils, HTTPProd, DSProd, OleServer,
  ASGSQLite3, DB;

type
  TWebModule2 = class(TWebModule)
    DataSetPageProducer1: TDataSetPageProducer;
    PageProducer2: TPageProducer;
    DataSetPageProducer2: TDataSetPageProducer;
    PageProducer1: TPageProducer;
    ASQLite3DB1: TASQLite3DB;
    ASQLite3Table1: TASQLite3Table;
    ASQLite3Query1: TASQLite3Query;
    PageProducer3: TPageProducer;
    ASQLite3Table2: TASQLite3Table;
    ASQLite3Table3: TASQLite3Table;
    procedure WebModuleCreate(Sender: TObject);
    procedure WebModuleDestroy(Sender: TObject);
    procedure WebModuleBeforeDispatch(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule2indexAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModuleAfterDispatch(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
    procedure PageProducer2HTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure WebModule2RegistAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure DataSetPageProducer1HTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure WebModule2UsrdelAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure PageProducer1HTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure PageProducer3HTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure WebModule2admin2Action(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
    procedure WebModule2admdelAction(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
    procedure WebModule2errorAction(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
    procedure WebModule2viewAction(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
    procedure WebModule2startAction(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
  private
    { Private declarations }
    title1, title2: string;
    head, body, foot, page: string;
    pos: integer;
    htmlw: Boolean;
    html: TStringList;
    admin_pass: string;
    r_name: string;
    home: string;
    page_def: integer;
    maxn, maxs, maxv, maxw: integer;
    maxline: integer;
    w_regist: Int64;
    autolink, tag: Boolean;
    mudai: string;
    re_color: string;
    hostview: integer;
    no_host, no_word: TStringList;
    l_count: integer;
    loginlist: TStringList;
    function LinkContent(path: string): string;
    function footer(path: string): string;
    function contentstring(dataset: TDataSetPageProducer): string;
    procedure createview;
  public
    { Public declarations }
  end;

const
    GAIBU: Boolean = true;
    LOCKEY: integer = 1;
    LOCK: string = 'lock/plock';

var
  WebModule2: TWebModule2;

implementation

uses WebReq, DateUtils;

{$R *.DFM}

procedure TWebModule2.WebModuleCreate(Sender: TObject);
begin
//ŏƃfobO[hƐݒuiKƂŋقȂ̂ōD܂Ȃ
//[JϐȊO錾Ă͂Ȃ
//* <body>^O */
        body := '<body bgcolor="#ddf2ed" text="#444444" link="#0000AA">';
//* y[W̕\L */
        page_def := 10;

        l_count:=5;
        pos:=-1;
//* iOA薼A{jSpƂ̔ł */
        maxn  := 40;
        maxs  := 40;
        maxv  := 1500;

        maxw:=160;
//* {̉s */
        maxline := 25;
//* zXg̘Ae𐧌
//  --> bLqƂ̎Ԉȏo߂ȂƘAełȂ*/
        w_regist := 5;
//* ŎN邩ǂiyes=1 no=0j*/
        autolink := true;
//* HTML^OLɂ邩iyes=1 no=0)*/
        tag := true;
//* ^Cgœeꂽꍇ */
        mudai := '()';
//* ̐F */
        re_color := '#225588';
//* zXg\邩i\Ȃ=0 <!-->ŕ\=1 \=2j*/
        hostview := 1;

        htmlw:=true;
//* O݋֎~ɂ?(=1,Ȃ=0) */
//define("GAIBU", 0);

//* gpt@CbÑ^Cvimkdir=1 flock=2 gȂ=0j*/
//define("LOCKEY", 2); 		//ʏ2OK
//* mkdirbNglockƂŃfBNg쐬777ɂĂ */
//define("LOCK" , "lock/plock");	//lock̒ɍ郍bNt@C
        no_host:=TStringList.Create;
        no_host.CommaText:='"kantei.go.jp","anonymizer.com","pt$","ph$","my$","th$","rr.com"';
        no_word:=TStringList.Create;
        no_word.CommaText:='"","n","novapublic"';
        loginlist:=TStringList.Create;
        loginlist.CommaText:='"/admin2","/admdel"';
        html:=TStringList.Create;
end;

procedure TWebModule2.WebModuleDestroy(Sender: TObject);
begin
        no_host.Free;
        no_word.Free;
        loginlist.Free;
        html.Free;
end;

procedure TWebModule2.WebModuleBeforeDispatch(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  i: integer;
  t: string;
begin
  with ASQLite3Query1 do
  begin
        ExecSQL;
        SQL.Clear;
        SQL.Add('CREATE TABLE if not exists pass(week integer, pass text);');
        ExecSQL;
        ASQLite3Table3.Active:=true;
  if ASQLite3Table3.RecordCount = 0 then
  begin
    for i:=1 to 7 do
    begin
        ASQLite3Table3.AppendRecord([i,'full']);
    end;
  end;
        SQL.Clear;
        SQL.Add('CREATE TABLE if not exists setting(home text, title1 text, title2 text);');
        ExecSQL;
        SQL.Clear;
        SQL.Add('SELECT * FROM setting;');
        Active:=true;
        t:='http://'+Request.Host+Request.InternalScriptName+'/';
  if (RecordCount = 0)and(Request.InternalPathInfo <> '/start') then
  begin
        Response.Content:='<form method="POST" action="'+t+'start">home : '+t+
          '<br>title1 : <input type=text name="title1" value="P-BBS" /><br>title2 : <textarea name="title2" col=5 row=10>'+
          '<font size=5 face=Verdana color=gray><b>P-BBS</b></font></textarea><br><input type=submit value="" /></form>';
        Handled:=true;
        Exit;
  end else
  begin
        home:=FieldByName('home').AsString;
        title1:=FieldByName('title1').AsString;
        title2:=FieldByName('title2').AsString;
  end;
  end;
        ASQLite3Table1.Active:=true;
        head:='<html><head><META HTTP-EQUIV="Content-type" CONTENT="text/html; charset=Shift_JIS"><title>'+
                title1+'</title></head>';
        foot:='[ <a href='+home+'>z[</a> ] [ <a href='+home+'admin>Ǘ</a> ]'+
                '<br><br><small><!-- P-BBS v1.232 -->- <a href="http://php.s3.to" target="_top">P-BBS</a> -</small>'+
                '</body></html>';
  if loginlist.IndexOf(Request.InternalPathInfo) = -1 then
  begin
    with Response.Cookies.Add do
    begin
        Name:='admin_pass';
        Value:='';
//        Secure:=true;
    end;
  end else
        if t = home then
  begin
        admin_pass:=ASQLite3Table3.Lookup('week',DayOfWeek(Now),'pass');
  end;
  for i:=0 to no_host.Count-1 do
  begin
    if AnsiContainsText(t,no_host[i]) = true then
    begin
        Response.StatusCode:=204;
        Handled:=true;
        break;
    end;
  end;
end;

procedure TWebModule2.WebModule2indexAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
        pos:=StrToIntDef(Request.Query,-1);
  if (htmlw = true)and(pos = -1) then
  begin
    if FileExists('index.html') = false then
    begin
        html.Text:=PageProducer2.Content;
        html.SaveToFile('index.html');
    end else
    begin
        html.LoadFromFile('index.html');
    end;
        Response.Content:=html.Text;
  end else
  begin
        r_name:=Request.CookieFields.Values['name'];
        Response.Content:=PageProducer2.Content;
  end;
end;

procedure TWebModule2.WebModuleAfterDispatch(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
        ASQLite3Table1.Active:=false;
        ASQLite3Table3.Active:=false;
end;

procedure TWebModule2.PageProducer2HTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
begin
  if TagString = 'page_def' then
  begin
        ReplaceText:=IntToStr(page_def);
  end;
  if TagString = 'home' then
  begin
        ReplaceText:=home;
  end;
  if TagString = 'main' then
  begin
        ReplaceText:=contentstring(DataSetPageProducer2);
  end;
  if TagString = 'title2' then
  begin
        ReplaceText:=title2;
  end;
  if TagString = 'r_name' then
  begin
        ReplaceText:=r_name;
  end;
  if TagString = 'foot' then
  begin
        ReplaceText:=footer('');
  end;
end;

procedure TWebModule2.WebModule2RegistAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  i: integer;
  s: string;
  l_name, pass, sub, com: string;
  x: TDateTime;
  y: Int64;
  procedure linecount;
  var
    j: integer;
    t: WideString;
    temp: TStringList;
  begin
        temp:=TStringList.Create;
    try
        temp.Text:=com;
      if temp.Count > maxline then
      begin
                s:=s+'s܂<br>';
      end else
      begin
                com:='';
        for j:=0 to temp.Count-1 do
        begin
                t:=temp[j];
          while Length(t) > maxw do
          begin
                com:=com+'<br>'+Copy(t,1,maxw);
                Delete(t,1,maxw);
          end;
                com:=com+'<br>'+t;
        end;
      end;
    finally
        temp.Free;
    end;
  end;
  procedure cookie;
  begin
    with Response.Cookies.Add do
    begin
        Name:='name';
        Value:=Request.Authorization;
    if Value = '' then
    begin
        Value:=Request.ContentFields.Values['name'];
    end;
        Expires:=Now+20;
    end;
  end;
begin
        s:='';
  if Request.Method <> 'POST' then
  begin
        s:=s+'sȓeȂł<br>';
  end;
  if (GAIBU = false)and(AnsiContainsStr('http://'+Request.Host+Request.InternalScriptName+Request.InternalPathInfo,home) = false) then
  begin
        s:=s+'O珑݂ł܂<br>';
  end;
        l_name:=Request.ContentFields.Values['name'];
        sub:=Request.ContentFields.Values['sub'];
        com:=Request.ContentFields.Values['com'];
        pass:=Request.ContentFields.Values['password'];
  if l_name = '' then
  begin
        l_name:='no name';
  end else
        if Length(name) > maxn then
  begin
        s:=s+'O܂<br>';
  end;
  if sub = '' then
  begin
        sub:=mudai;
  end else
        if Length(sub) > maxs then
  begin
        s:=s+'^Cg܂<br>';
  end;
  if com = '' then
  begin
        s:=s+'{܂Ă܂<br>';
  end else
        if Length(com) > maxv then
  begin
        s:=s+'{܂<br>';
  end;
  for i:=0 to no_word.Count-1 do
  begin
    if (AnsiContainsText(com,no_word[i]) = true)or(AnsiContainsText(sub,no_word[i]) = true)or
      (AnsiContainsText(name,no_word[i]) = true) then
    begin
        s:=s+'gpłȂt܂܂Ă܂<br>';
    end;
  end;
        ASQLite3Table1.Last;
        x:=Now;
        y:=SecondsBetween(x,ASQLite3Table1.FieldByName('date').AsFloat);
  if (ASQLite3Table1.FieldByName('com').AsString = com)and
    (ASQLite3Table1.FieldByName('name').AsString = name) then
  begin
        Response.SendRedirect(home);
        Exit;
  end;
  if y < w_regist then
  begin
        s:=s+'ݍĂ܂@c'+IntToStr(w_regist-y)+'b<br>';
  end;
        linecount;
        cookie;
  if s <> '' then
  begin
        Response.Content:=head+s+'uEU̖߂ňړĂB</body></html>';
  end else
  begin
    if Request.ContentFields.Values['property'] = 'view' then
    begin
        createview;
      with ASQLite3Table2 do
      begin
        Active:=true;
      if Bof and Eof then
      begin
                i:=1;
      end else
      begin
                i:=FieldByName('no').AsInteger+1;
      end;
        AppendRecord([pass,i,Now,l_name,sub,com]);
        Active:=false;
      end;
        Response.Content:='<table border=1><tr><td>O</td><td>'+l_name+'</td></tr><tr><td>^Cg</td><td>'+
          sub+'</td></tr><tr><td>Rg</td><td>'+com+'</td></tr></table><form method=post action='+home+
          'view?'+IntToStr(i)+'><input type=submit value="">ꍇ̓uEU̖߂';
        Exit;
    end;
    with ASQLite3Table1 do
    begin
        Last;
    if RecordCount = 0 then
    begin
        i:=0
    end else
    begin
        i:=FieldByName('no').AsInteger+1;
    end;
        AppendRecord([pass,i,Request.Date,l_name,sub,com]);
    end;
        pos:=-1;
    if htmlw = true then
    begin
        html.Text:=PageProducer2.Content;
        html.SaveToFile('index.html');
    end;
        Response.SendRedirect(home);
  end;
end;

procedure TWebModule2.DataSetPageProducer1HTMLTag(Sender: TObject;
  Tag: TTag; const TagString: String; TagParams: TStrings;
  var ReplaceText: String);
begin
  if TagString = 'home' then
  begin
        ReplaceText:=home;
  end else
        if TagString = 'now' then
  begin
        ReplaceText:=DateTimeToStr(ASQLite3Table1.FieldByName('date').AsFloat);
  end else
  begin
        ReplaceText:=ASQLite3Table1.FieldByName(TagString).AsString;
  end;
end;

procedure TWebModule2.WebModule2UsrdelAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  s, t: string;
  no, pwd: string;
begin
        no:=Request.ContentFields.Values['no'];
        pwd:=Request.ContentFields.Values['pwd'];
  if (no = '')or(pwd = '') then
  begin
        t:='폜no܂͍폜L[͂ł';
  end;
  if ASQLite3Table1.Locate('no',no,[]) = false then
  begin
        t:='YL܂';
  end else
  begin
        s:=ASQLite3Table1.FieldByName('pwd').AsString;
    if s = '' then
    begin
        t:='YLɂ͍폜L[ݒ肳Ă܂)';
    end else
        if s <> pwd then
    begin
        t:='폜L[Ⴂ܂';
    end else
    begin
        ASQLite3Table1.Delete;
    end;
  end;
  if t = '' then
  begin
        Response.SendRedirect(home);
  end else
  begin
        Response.Content:=head+t+'</body></html>';
  end;
end;

procedure TWebModule2.PageProducer1HTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
begin
  if TagString = 'home' then
  begin
        ReplaceText:=home;
  end;
  if TagString = 'main' then
  begin
        ReplaceText:=contentstring(DataSetPageProducer1);
  end;
  if TagString = 'pos' then
  begin
        ReplaceText:=IntToStr(pos);
  end;
end;

procedure TWebModule2.PageProducer3HTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
begin
  if TagString = 'home' then
  begin
        ReplaceText:=home;
  end;
end;

procedure TWebModule2.WebModule2admin2Action(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  pwd: string;
begin
  if (Request.ContentFields.IndexOfName('apass') = -1)or(Request.MethodType <> mtPost) then
  begin
        pwd:=Request.CookieFields.Values['admin_pass'];
  end else
  begin
        pwd:=Request.ContentFields.Values['apass'];
  end;
  if (admin_pass = pwd)and(admin_pass <> '') then
  begin
        pos:=StrToIntDef(Request.Query,-1);
        Response.Content:=PageProducer1.Content+footer('admin2');
    with Response.Cookies.Add do
    begin
        Name:='admin_pass';
        Value:=pwd;
//        Secure:=true;
    end;
  end else
  begin
    if Request.MethodType <> mtPost then
    begin
        Response.Content:='OCĂ';
    end else
    begin
        Response.Content:='pX[h܂';
    end;
  end;
end;

procedure TWebModule2.WebModule2admdelAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  i, j: integer;
  s: string;
begin
  if (admin_pass <> '')and(Request.CookieFields.Values['admin_pass'] = admin_pass) then
  begin
    for i:=0 to Request.ContentFields.Count-1 do
    begin
        s:=Request.ContentFields.Values[Request.ContentFields.Names[i]];
      if ASQLite3Table1.Locate('no',StrToInt(s),[]) = true then
      begin
                ASQLite3Table1.Delete;
      end;
    end;
    if htmlw = true then
    begin
        j:=pos;
        pos:=-1;
        html.Text:=PageProducer2.Content;
        html.SaveToFile('index.html');
        pos:=j;
    end;
  end;
        Response.SendRedirect(home+'admin2?'+Request.Query);
end;

function TWebModule2.LinkContent(path: string): string;
var
  i, j: integer;
begin
        result:='';
  if pos > l_count div 2 then
  begin
        j:=-(l_count div 2);
  end else
  begin
        j:=-pos;
  end;
  for i:=0 to l_count-1 do
  begin
    if ASQLite3Table1.RecordCount < (pos+i+j)*page_def then
    begin
        break;
    end;
    if i+j = 0 then
    begin
        result:=result+'@'+IntToStr(pos)+'@';
    end else
    begin
        result:=result+Format('@<a href="'+home+path+'?%d">%d</a>@',[pos+i+j,pos+i+j]);
    end;
  end;
end;

procedure TWebModule2.WebModule2errorAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
        Response.SendRedirect(home);
end;

function TWebModule2.footer(path: string): string;
var
  s, t, u: string;
  i: integer;
begin
  if pos <= -1 then
  begin
        s:='<hr size=1>ŐV%d̋L\<br><center>Pages:[<b>';
        page:='<<'+LinkContent(path)+'>>]@ŐV<br></center>';
        result:=Format(s,[page_def])+page+foot;
  end else
  begin
    if pos = 0 then
    begin
        t:='?0';
        u:='?'+IntToStr(pos+1);
    end else
    begin
        i:=ASQLite3Table1.RecordCount div page_def;
        t:='?'+IntToStr(pos-1);
      if pos = i then
      begin
                u:='?'+IntToStr(i);
      end else
      begin
                u:='?'+IntToStr(pos+1);
      end;
    end;
        page:='<a href="'+home+path+t+'"><<</a>'+LinkContent(path)+
                '<a href="'+home+path+u+'">>></a>]@<a href="'+home+path+'">ŐV</a></b></center>';
        s:='<hr size=1>%d@<br> %d Ԗڂ %d Ԗڂ̋L\<br><center>Page:[<b>';
        result:=Format(s,[ASQLite3Table1.RecordCount,pos*page_def,(pos+1)*page_def-1])+page+foot;
  end;
end;

procedure TWebModule2.WebModule2viewAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  i: integer;
  p, n, d, s, c: string;
begin
        i:=StrToIntDef(Request.Query,0);
  if i > 0 then
  begin
        createview;
    with ASQLite3Table2 do
    begin
        Active:=true;
    if Locate('no',i,[]) = true then
    begin
        p:=FieldByName('pass').AsString;
        n:=FieldByName('name').AsString;
        d:=FieldByName('date').AsString;
        s:=FieldByName('sub').AsString;
        c:=FieldByName('com').AsString;
      with ASQLite3Table1 do
      begin
      if Eof and Bof then
      begin
                i:=0;
      end else
      begin
                Last;
                i:=FieldByName('no').AsInteger+1;
      end;
        AppendRecord([p,i,d,n,s,c]);
      end;
        Delete;
        pos:=-1;
      if htmlw = true then
      begin
                html.Text:=PageProducer2.Content;
                html.SaveToFile('index.html');
      end;
    end;
        Active:=false;
    end;
  end;
        Response.SendRedirect(home);
end;

function TWebModule2.contentstring(dataset: TDataSetPageProducer): string;
var
  i: integer;
begin
  with ASQLite3Table1 do
  begin
  if (pos < -1)or((pos+1)*page_def > RecordCount) then
  begin
    if pos < -1 then
    begin
        pos:=0;
    end else
    begin
        pos:=RecordCount div page_def;
    end;
  end;
  if pos = -1 then
  begin
    if RecordCount > page_def then
    begin
        RecNo:=RecordCount-page_def+1;
    end else
    begin
        First;
    end;
  end else
  begin
        RecNo:=pos*page_def+1;
  end;
        i:=0;
  while (Eof = false)and(i < page_def) do
  begin
        result:=dataset.Content+result;
        Next;
        inc(i);
  end;
  end;
end;

procedure TWebModule2.WebModule2startAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  h, t1, t2: string;
  x: Boolean;
begin
        h:='http://'+Request.Host+Request.InternalScriptName+'/';
        t1:=Request.ContentFields.Values['title1'];
        t2:=Request.ContentFields.Values['title2'];
  with ASQLite3Table2 do
  begin
        TableName:='setting';
        Active:=true;
        x:=Eof and Bof;
    if x = true then
    begin
        AppendRecord([h,t1,t2]);
    end;
        Active:=false;
        TableName:='view';
  end;
  if x = true then
  begin
        Response.SendRedirect(h);
  end else
  begin
        Response.Content:='error';
  end;
end;

procedure TWebModule2.createview;
begin
  with ASQLite3Query1 do
  begin
        SQL.Clear;
        SQL.Add('CREATE TABLE if not exists view(pass text, no integer, date real, name text, sub text, com text);');
        ExecSQL;
  end;
end;

initialization
  if WebRequestHandler <> nil then
    WebRequestHandler.WebModuleClass := TWebModule2;

end.
