package jp.sf.beanbinder.annotations;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;

@Retention(RUNTIME)
public @interface Column {
    public String displayProp() default "";
    public String valueProp() default "";
    public String idProp() default "";
    public String text();
    public boolean readOnly() default false;
    public String prop() default "";
    public int width() default 100;
    
    public IMEMode imeMode() default IMEMode.DEFAULT;
    public AlignType horizon() default AlignType.LEFT;
    public AlignType vertical() default AlignType.TOP;
    public String validatorField() default "";
    public String formatField() default "";
    public String cellEditorField() default "";
    public String cellRendererField() default "";
}
