/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.beanbinder.strategy.swing;

import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.BindProperty;
import jp.sf.beanbinder.editor.CellEditor;
import jp.sf.beanbinder.editor.swing.SwingCellEditor;
import jp.sf.beanbinder.exception.ValidateException;
import jp.sf.beanbinder.strategy.ComponentStrategy;
import jp.sf.beanbinder.strategy.swing.DefaultTableCellRenderer;
import jp.sf.beanbinder.strategy.swing.IMEFocusListener;
import jp.sf.beanbinder.strategy.swing.JTableModel;
import jp.sf.beanbinder.strategy.swing.MultiSelectable;
import jp.sf.beanbinder.strategy.swing.TableSorter;

public final class JTableStrategy
implements ComponentStrategy,
MultiSelectable {
    static /* synthetic */ Class class$0;

    public void updateBean(Object bean, Bind bind, Object component) {
        try {
            this.validate(bind, component);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void validate(Bind bind, Object component) throws ValidateException {
        JTable table = (JTable)bind.getComponent();
        JTableModel model = this.getTableModel(table);
        int row = 0;
        while (row < table.getRowCount()) {
            int column = 0;
            while (column < table.getColumnCount()) {
                Object value = model.getProperty(row, column);
                try {
                    model.setValueAt(value, row, column);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                ++column;
            }
            ++row;
        }
    }

    public void updateDisplay(Bind bind, Object component, Object value) {
        TableModelListener listener;
        Collection collection = (Collection)value;
        JTable table = (JTable)component;
        AbstractTableModel oldModel = (AbstractTableModel)table.getModel();
        if (oldModel instanceof TableSorter) {
            oldModel = (AbstractTableModel)((TableSorter)oldModel).getTableModel();
        }
        JTableModel newModel = new JTableModel(table, collection, bind);
        int i = 0;
        while (i < oldModel.getTableModelListeners().length) {
            listener = oldModel.getTableModelListeners()[i];
            newModel.addTableModelListener(listener);
            ++i;
        }
        i = 0;
        while (i < newModel.getTableModelListeners().length) {
            listener = newModel.getTableModelListeners()[i];
            oldModel.removeTableModelListener(listener);
            ++i;
        }
        if (bind.isSortable()) {
            TableSorter sorter = new TableSorter(newModel);
            table.setModel(sorter);
            sorter.setTableHeader(table.getTableHeader());
        } else {
            table.setModel(newModel);
        }
        i = 0;
        while (i < bind.getProperties().size()) {
            BindProperty prop = bind.getProperty(i);
            table.setRowHeight(prop.getHeight());
            table.getColumn(table.getColumnName(i)).setPreferredWidth(prop.getWidth());
            CellEditor editor = prop.getColumnProperty().getCellEditor();
            if (editor == null) {
                final JTextField txt = new JTextField();
                txt.setBorder(null);
                prop.getColumnProperty().setCellEditor(editor);
                editor = new CellEditor(){

                    public Object getComponent() {
                        return txt;
                    }

                    public Object getCellEditorValue() {
                        return ((JTextField)this.getComponent()).getText();
                    }

                    public void updateCellEditor(Object value, int row, int col) {
                        ((JTextField)this.getComponent()).setText(value == null ? "" : value.toString());
                    }
                };
                FocusListener[] listeners = txt.getFocusListeners();
                int k = 0;
                while (k < listeners.length) {
                    FocusListener fl = listeners[k];
                    if (fl instanceof IMEFocusListener) {
                        txt.removeFocusListener(fl);
                    }
                    ++k;
                }
                txt.addFocusListener(new IMEFocusListener(bind.getProperty(i)));
            }
            table.getColumnModel().getColumn(i).setCellEditor(new SwingCellEditor(newModel, collection, bind, editor));
            ++i;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        table.setDefaultRenderer(clazz, new DefaultTableCellRenderer(bind, collection));
        table.updateUI();
    }

    public void updateComponent(Bind bind, Object component) {
    }

    public void selectBean(Bind bind, Object component, Object[] bean) {
        JTable table = (JTable)component;
        JTableModel model = this.getTableModel(table);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int k = 0;
        while (k < bean.length) {
            Object obj = bean[k];
            int i = 0;
            while (i < model.bean.size()) {
                if (model.bean.toArray()[i].equals(obj)) {
                    indices.add(new Integer(i));
                }
                ++i;
            }
            ++k;
        }
        if (indices.size() > 0) {
            table.setRowSelectionInterval((Integer)indices.get(0), (Integer)indices.get(0));
        }
    }

    public Object[] getSelectedBean(Bind bind, Object component) {
        return (Object[])this.getValue(bind, component);
    }

    public void setEditable(Bind bind, Object component) {
        JTable table = (JTable)component;
        JTableModel model = this.getTableModel(table);
        model.bind = bind;
    }

    public Object getValue(Bind bind, Object component) {
        JTable table = (JTable)component;
        JTableModel model = this.getTableModel(table);
        int[] indices = table.getSelectedRows();
        if (indices.length <= 0) {
            return null;
        }
        Object[] results = new Object[indices.length];
        int i = 0;
        while (i < indices.length) {
            results[i] = model.bean.toArray()[indices[i]];
            ++i;
        }
        return results;
    }

    private JTableModel getTableModel(JTable table) {
        if (table.getModel() instanceof TableSorter) {
            return (JTableModel)((TableSorter)table.getModel()).getTableModel();
        }
        return (JTableModel)table.getModel();
    }
}

