package view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.text.DecimalFormat;
import java.text.Format;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.WindowConstants;

import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.BeanBinderFactory;
import jp.sf.beanbinder.annotations.AlignType;
import jp.sf.beanbinder.annotations.Basic;
import jp.sf.beanbinder.annotations.Column;
import jp.sf.beanbinder.annotations.IMEMode;
import jp.sf.beanbinder.annotations.Select;
import jp.sf.beanbinder.annotations.Table;
import jp.sf.beanbinder.editor.CellEditor;
import jp.sf.beanbinder.validator.NumberValidator;
import jp.sf.beanbinder.validator.RangeValidator;
import jp.sf.beanbinder.validator.ValidateContainer;
import jp.sf.beanbinder.validator.ValidateDisplay;
import jp.sf.beanbinder.validator.swing.SwingValidateDisplay;
import jp.sf.beanbinder.xml.XMLParser;
import controller.AddProduct;
import controller.Controller;
import controller.PickProduct;

public class ExampleWindow extends JFrame implements ActionListener, MouseListener {
    public BeanBinder binder = BeanBinderFactory.createSwingBinder();
    private Controller addProduct = new AddProduct();
    private Controller pickProduct = new PickProduct();
    
    private Format format1 = new DecimalFormat("###,###,###");
    
    //Validatorの作成
    private ValidateDisplay validateDisplay;
    private ValidateContainer validator1 = new ValidateContainer();
    
    //編集画面のマッピング    
    @Basic(objectKey="product", prop="code", group="group1" )
    private JTextField codeTextBox = null;
    
    @Basic(objectKey="product", prop="name", imeMode=IMEMode.JP, group="group1" )
    private JTextField nameTextBox = null;

    @Select( destKey="product", destValueProp="maker", destIdProp="maker.id",
            srcKey="makerList", srcDisplayProp="name", srcIdProp="id",
            group="group1" )
    private JComboBox makerComboBox = null;

    @Basic(objectKey="product", prop="unitPrice", validatorField="validator1", horizon=AlignType.RIGHT, group="group1" )
    private JTextField unitPriceTextBox = null;

    @Basic(objectKey="product", prop="remarks", imeMode=IMEMode.JP, group="group1" )
    private JTextField remarksTextBox = null;
    
    //商品表のマッピング
    @Table(objectKey="productList",
            columns = {
                @Column(prop="code", text="品番"),
                @Column(prop="name", text="品名"),
                @Column(prop="unitPrice", text="単価", formatField="format1", horizon=AlignType.RIGHT),
                @Column(displayProp="maker.name", valueProp="maker", text="メーカー", cellEditorField="cellEditor1"),
                @Column(prop="remarks", text="備考")
            }
    )
    private JTable productTable = null;
    
    //商品表のセルエディタをマッピング
    @Select( srcKey="makerList", srcDisplayProp="name" )
    private JComboBox combo = new JComboBox();
    private CellEditor cellEditor1 = new MakerCellEditor(this.binder, combo);
    
    
    //下記の多くの記述はVisualEditorによって自動的に生成されています。
    private static final long serialVersionUID = 1L;

    private JPanel jContentPane = null;

    private JScrollPane jScrollPane = null;

    private JPanel jPanel = null;

    private JLabel jLabel = null;

    private JLabel jLabel1 = null;

    private JLabel validateLabel = null;

    private JLabel jLabel3 = null;

    private JLabel jLabel4 = null;

    private JLabel jLabel5 = null;

    private JButton addButton = null;

    /**
     * This is the default constructor
     */
    public ExampleWindow() {
        super();
        initialize();
        
        this.mapping();
        
        this.getAddButton().addActionListener(this);
        this.getProductTable().addMouseListener(this);
    }
    public void mapping() {
        //Validatorの作成
        this.validateDisplay = new SwingValidateDisplay(this.validateLabel);
        this.validator1.addValidator(new NumberValidator("単価を正しく入力して下さい。", this.validateDisplay));
        this.validator1.addValidator(new RangeValidator(0, 9999999, "入力可能な範囲は0～9999999までです。", this.validateDisplay));
        
        //XMLからマッピング
        new XMLParser(this.binder, this, new File("./example_window.xml")).parse();
    }
    
    public void actionPerformed(ActionEvent e) {
        if( e.getSource().equals(this.getAddButton()) ) {
            this.addProduct.execute(this.binder);
        }
    }
    public void mouseClicked(MouseEvent e) {
        this.pickProduct.execute(this.binder);
    }
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}

    /**
     * This method initializes this
     * 
     * @return void
     */
    private void initialize() {
        this.setSize(583, 439);
        this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        this.setContentPane(getJContentPane());
        this.setTitle("BeanBinder Example");
    }

    /**
     * This method initializes jContentPane
     * 
     * @return javax.swing.JPanel
     */
    private JPanel getJContentPane() {
        if (jContentPane == null) {
            jContentPane = new JPanel();
            jContentPane.setLayout(new BorderLayout());
            jContentPane.add(getJScrollPane(), BorderLayout.SOUTH);
            jContentPane.add(getJPanel(), BorderLayout.CENTER);
        }
        return jContentPane;
    }

    /**
     * This method initializes jScrollPane	
     * 	
     * @return javax.swing.JScrollPane	
     */
    private JScrollPane getJScrollPane() {
        if (jScrollPane == null) {
            jScrollPane = new JScrollPane();
            jScrollPane.setPreferredSize(new Dimension(0, 200));
            jScrollPane.setViewportView(getProductTable());
        }
        return jScrollPane;
    }

    /**
     * This method initializes productTable	
     * 	
     * @return javax.swing.JTable	
     */
    private JTable getProductTable() {
        if (productTable == null) {
            productTable = new JTable();
        }
        return productTable;
    }

    /**
     * This method initializes jPanel	
     * 	
     * @return javax.swing.JPanel	
     */
    private JPanel getJPanel() {
        if (jPanel == null) {
            jLabel5 = new JLabel();
            jLabel5.setBounds(new Rectangle(10, 160, 91, 21));
            jLabel5.setHorizontalAlignment(SwingConstants.CENTER);
            jLabel5.setText("備考");
            jLabel4 = new JLabel();
            jLabel4.setBounds(new Rectangle(10, 100, 91, 21));
            jLabel4.setHorizontalAlignment(SwingConstants.CENTER);
            jLabel4.setText("メーカー");
            jLabel3 = new JLabel();
            jLabel3.setBounds(new Rectangle(10, 130, 91, 21));
            jLabel3.setHorizontalAlignment(SwingConstants.CENTER);
            jLabel3.setText("単価");
            validateLabel = new JLabel();
            validateLabel.setBounds(new Rectangle(10, 10, 541, 21));
            validateLabel.setForeground(Color.red);
            validateLabel.setText("");
            jLabel1 = new JLabel();
            jLabel1.setBounds(new Rectangle(10, 70, 91, 21));
            jLabel1.setHorizontalAlignment(SwingConstants.CENTER);
            jLabel1.setText("品名");
            jLabel = new JLabel();
            jLabel.setBounds(new Rectangle(10, 40, 91, 21));
            jLabel.setHorizontalAlignment(SwingConstants.CENTER);
            jLabel.setText("品番");
            jPanel = new JPanel();
            jPanel.setLayout(null);
            jPanel.add(jLabel, null);
            jPanel.add(jLabel1, null);
            jPanel.add(validateLabel, null);
            jPanel.add(jLabel3, null);
            jPanel.add(jLabel4, null);
            jPanel.add(jLabel5, null);
            jPanel.add(getCodeTextBox(), null);
            jPanel.add(getMakerComboBox(), null);
            jPanel.add(getNameTextBox(), null);
            jPanel.add(getUnitPriceTextBox(), null);
            jPanel.add(getRemarksTextBox(), null);
            jPanel.add(getAddButton(), null);
        }
        return jPanel;
    }

    /**
     * This method initializes codeTextBox	
     * 	
     * @return javax.swing.JTextField	
     */
    private JTextField getCodeTextBox() {
        if (codeTextBox == null) {
            codeTextBox = new JTextField();
            codeTextBox.setBounds(new Rectangle(110, 40, 131, 21));
        }
        return codeTextBox;
    }

    /**
     * This method initializes makerComboBox	
     * 	
     * @return javax.swing.JComboBox	
     */
    private JComboBox getMakerComboBox() {
        if (makerComboBox == null) {
            makerComboBox = new JComboBox();
            makerComboBox.setBounds(new Rectangle(110, 100, 191, 21));
        }
        return makerComboBox;
    }

    /**
     * This method initializes nameTextBox	
     * 	
     * @return javax.swing.JTextField	
     */
    private JTextField getNameTextBox() {
        if (nameTextBox == null) {
            nameTextBox = new JTextField();
            nameTextBox.setBounds(new Rectangle(110, 70, 261, 21));
        }
        return nameTextBox;
    }

    /**
     * This method initializes unitPriceTextBox	
     * 	
     * @return javax.swing.JTextField	
     */
    private JTextField getUnitPriceTextBox() {
        if (unitPriceTextBox == null) {
            unitPriceTextBox = new JTextField();
            unitPriceTextBox.setBounds(new Rectangle(110, 130, 101, 21));
        }
        return unitPriceTextBox;
    }

    /**
     * This method initializes remarksTextBox	
     * 	
     * @return javax.swing.JTextField	
     */
    private JTextField getRemarksTextBox() {
        if (remarksTextBox == null) {
            remarksTextBox = new JTextField();
            remarksTextBox.setBounds(new Rectangle(110, 160, 261, 21));
        }
        return remarksTextBox;
    }

    /**
     * This method initializes addButton	
     * 	
     * @return javax.swing.JButton	
     */
    private JButton getAddButton() {
        if (addButton == null) {
            addButton = new JButton();
            addButton.setBounds(new Rectangle(420, 160, 131, 21));
            addButton.setText("追加 / 編集");
        }
        return addButton;
    }

}  //  @jve:decl-index=0:visual-constraint="10,10"
