/*
 * Decompiled with CFR 0.152.
 */
package ams.com.ams.beanql;

import ams.com.ams.beanql.BeanQLTransaction;
import ams.com.ams.beanql.ColumnProperty;
import ams.com.ams.beanql.Log;
import ams.com.ams.beanql.exceptions.BeanQLException;
import ams.com.ams.beanql.vendor.DBDependQLStatement;
import ams.com.ams.beanql.vendor.DBDependQLStatementFactory;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class BeanQLManager {
    private String driverName = "";
    private String url = "";
    private String user = "";
    private String password = "";
    private Driver driver;
    private int vendorType;
    private boolean autoCrateTable = false;
    private String sequenceTable;
    private DataSource ds;
    public static int VENDOR_UNKNOWN = 0;
    public static int VENDOR_ORACLE = 1;
    public static int VENDOR_MYSQL = 2;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public BeanQLManager(String driver_name, String url, String user, String password, int vendor_type, String sequence_table) throws BeanQLException {
        this.initialize(driver_name, url, user, password, vendor_type, sequence_table);
    }

    public BeanQLManager(DataSource ds, int vendor_type, String sequence_table) throws BeanQLException {
        this.initialize(ds, vendor_type, sequence_table);
    }

    private void initialize(DataSource ds, int vendor_type, String sequence_table) throws BeanQLException {
        this.ds = ds;
        this.vendorType = vendor_type;
        this.sequenceTable = sequence_table;
        Log.println("[BeanQLManager#initialize() start --->");
        if (this.isExistTable(this.sequenceTable)) {
            return;
        }
        Log.println("[BeanQLManager#initialize() creating SequenceTable");
        this.createSequenceTable();
        Log.println("[BeanQLManager#initialize() end <---");
    }

    private void initialize(String driver_name, String url, String user, String password, int vendor_type, String sequence_table) throws BeanQLException {
        this.driverName = driver_name;
        this.url = url;
        this.user = user;
        this.password = password;
        this.vendorType = vendor_type;
        this.sequenceTable = sequence_table;
        try {
            this.driver = (Driver)Class.forName(driver_name).newInstance();
        }
        catch (InstantiationException e) {
            throw new BeanQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new BeanQLException(e);
        }
        catch (ClassNotFoundException e) {
            throw new BeanQLException("Driver Class not found:" + this.driverName + "\n" + e);
        }
        if (this.isExistTable(this.sequenceTable)) {
            return;
        }
        this.createSequenceTable();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSequenceTable() throws BeanQLException {
        BeanQLTransaction bt = this.getBeanQLTransaction();
        ColumnProperty[] cp = new ColumnProperty[2];
        cp[0] = new ColumnProperty();
        cp[0].setName("tableName");
        cp[0].setNullable(false);
        ColumnProperty columnProperty = cp[0];
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        columnProperty.setType(clazz);
        cp[0].setDefaultValue("");
        cp[0].setPrimaryKey(true);
        cp[0].setSize(100);
        cp[1] = new ColumnProperty();
        cp[1].setName("sequence");
        cp[1].setNullable(false);
        ColumnProperty columnProperty2 = cp[1];
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz3 = class$1 = clazz4;
        }
        columnProperty2.setType(clazz3);
        cp[1].setDefaultValue(new Integer(1));
        cp[1].setPrimaryKey(false);
        try {
            try {
                DBDependQLStatement dqs = DBDependQLStatementFactory.create(bt.getConnection(), bt.mgr);
                Log.println("[BeanQLManager#createSequenceTable() creating SequenceTable");
                dqs.createTable(this.sequenceTable, cp);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BeanQLException("cannot create table:" + this.sequenceTable, e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            bt.close();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        bt.close();
        Log.println("[BeanQLManager#createSequenceTable() create SequenceTable ok");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isExistTable(String table_name) throws BeanQLException {
        boolean bl;
        BeanQLTransaction bt = this.getBeanQLTransaction();
        try {
            try {
                DBDependQLStatement dqs = DBDependQLStatementFactory.create(bt.getConnection(), bt.mgr);
                bl = dqs.isExistTable(table_name);
                Object var4_6 = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BeanQLException("cannot check exist table:" + table_name, e);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            bt.close();
            throw throwable;
        }
        bt.close();
        return bl;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public BeanQLTransaction getBeanQLTransaction() throws BeanQLException {
        if (this.ds != null) {
            try {
                Connection con = this.ds.getConnection();
                Log.println("[BeanQL] connect. (DataSource): " + this.ds);
                return new BeanQLTransaction(con, this);
            }
            catch (SQLException e) {
                throw new BeanQLException(String.valueOf(e.getMessage()) + "\nDataSource connect error :" + this.ds);
            }
        }
        if (this.driver == null) {
            throw new BeanQLException("not loaded driver.");
        }
        Properties props = new Properties();
        props.put("user", this.user);
        props.put("password", this.password);
        try {
            Connection con = this.driver.connect(this.url, props);
            Log.println("[BeanQL] connect. user:" + this.user + " password:" + this.password + " url:" + this.url);
            return new BeanQLTransaction(con, this);
        }
        catch (SQLException e) {
            throw new BeanQLException(String.valueOf(e.getMessage()) + "\nJDBC connect error (check parameter:user " + this.user + ", url " + this.url, e);
        }
    }

    public BeanQLTransaction getBeanQLTransaction(Connection con) throws BeanQLException {
        return new BeanQLTransaction(con, this);
    }

    public int getVendorType() {
        return this.vendorType;
    }

    public boolean isAutoCrateTable() {
        return this.autoCrateTable;
    }

    public void setAutoCrateTable(boolean b) {
        this.autoCrateTable = b;
    }

    public String getSequenceTable() {
        return this.sequenceTable;
    }
}

