/*
 * Decompiled with CFR 0.152.
 */
package ams.com.ams.beanql;

import ams.com.ams.beanql.BeanQLManager;
import ams.com.ams.beanql.BeanQLPreparedStatement;
import ams.com.ams.beanql.BeanQLSimpleViewStatement;
import ams.com.ams.beanql.BeanQLStatement;
import ams.com.ams.beanql.BeanQLViewPreparedStatement;
import ams.com.ams.beanql.Log;
import ams.com.ams.beanql.exceptions.BeanQLException;
import ams.com.ams.beanql.exceptions.BeanQLTableNotFoundException;
import java.sql.Connection;
import java.sql.SQLException;

public class BeanQLTransaction {
    private Connection connection;
    BeanQLManager mgr;

    BeanQLTransaction(Connection con, BeanQLManager mgr) throws BeanQLException {
        if (con == null) {
            throw new BeanQLException("Connection is null.");
        }
        this.setConnection(con);
        this.mgr = mgr;
    }

    void setConnection(Connection con) {
        this.connection = con;
    }

    public void setAutoCommit(boolean b) throws BeanQLException {
        try {
            this.connection.setAutoCommit(b);
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public void close() throws BeanQLException {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                Log.println("[BeanQL] closed.");
            }
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public BeanQLStatement createStatement(Class bean_class) throws BeanQLException, BeanQLTableNotFoundException {
        try {
            return new BeanQLStatement(bean_class, this.connection.createStatement(), this);
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public BeanQLStatement createStatement(String bean_class_name) throws BeanQLException, BeanQLTableNotFoundException {
        Class<?> bean_class;
        try {
            bean_class = Class.forName(bean_class_name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new BeanQLException("cannot create class :" + bean_class_name, e);
        }
        return this.createStatement(bean_class);
    }

    public void commit() throws BeanQLException {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public void rollback() throws BeanQLException {
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.rollback();
            }
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public BeanQLSimpleViewStatement createSimpleViewStatement(Class bean_class) throws BeanQLException {
        try {
            return new BeanQLSimpleViewStatement(bean_class, this.connection.createStatement(), this);
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public BeanQLPreparedStatement createPreparedStatement(Class bean_class, String sql) throws BeanQLTableNotFoundException, BeanQLException {
        try {
            return new BeanQLPreparedStatement(bean_class, this.connection.prepareStatement(sql), this);
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public BeanQLPreparedStatement createPreparedStatement(String bean_class_name, String sql) throws BeanQLTableNotFoundException, BeanQLException {
        Class<?> bean_class;
        try {
            bean_class = Class.forName(bean_class_name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new BeanQLException("cannot create class :" + bean_class_name, e);
        }
        return this.createPreparedStatement(bean_class, sql);
    }

    public BeanQLViewPreparedStatement createViewPreparedStatement(Class bean_class, String sql) throws BeanQLException {
        try {
            return new BeanQLViewPreparedStatement(bean_class, this.connection.prepareStatement(sql));
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public BeanQLViewPreparedStatement createViewPreparedStatement(String bean_class_name, String sql) throws BeanQLException {
        Class<?> bean_class;
        try {
            bean_class = Class.forName(bean_class_name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new BeanQLException("cannot create class :" + bean_class_name, e);
        }
        return this.createViewPreparedStatement(bean_class, sql);
    }
}

