/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.beanql;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import jp.co.powerbeans.beanql.BeanQLTransaction;
import jp.co.powerbeans.beanql.ColumnProperty;
import jp.co.powerbeans.beanql.Log;
import jp.co.powerbeans.beanql.dao.BeanQLDAO;
import jp.co.powerbeans.beanql.dao.BeanQLDynaViewDAO;
import jp.co.powerbeans.beanql.dao.BeanQLStandardDAO;
import jp.co.powerbeans.beanql.dao.BeanQLStandardDynaViewDAO;
import jp.co.powerbeans.beanql.dao.BeanQLStandardViewDAO;
import jp.co.powerbeans.beanql.dao.BeanQLViewDAO;
import jp.co.powerbeans.beanql.exceptions.BeanQLException;
import jp.co.powerbeans.beanql.exceptions.BeanQLExceptionListener;
import jp.co.powerbeans.beanql.vendor.DBDependQLStatement;
import jp.co.powerbeans.beanql.vendor.DBDependQLStatementFactory;

public class BeanQLManager {
    private String driverName = "";
    private String url = "";
    private String user = "";
    private String password = "";
    private Driver driver;
    private int vendorType;
    private boolean autoCreateTable = false;
    private String sequenceTable;
    private DataSource ds;
    public static int VENDOR_UNKNOWN = 0;
    public static int VENDOR_ORACLE = 1;
    public static int VENDOR_MYSQL = 2;
    public static final int VENDOR_DB2 = 3;
    public static final int VENDOR_POSTGRESQL = 4;
    private Class blobClass;
    private Map customDAO;
    private BeanQLExceptionListener exceptionListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public BeanQLManager(String driver_name, String url, String user, String password, String sequence_table) throws BeanQLException {
        this.initialize(driver_name, url, user, password, sequence_table, null);
    }

    public BeanQLManager(String driver_name, String url, String user, String password, String sequence_table, Map custom_dao) throws BeanQLException {
        this.initialize(driver_name, url, user, password, sequence_table, custom_dao);
    }

    public BeanQLManager(DataSource ds, String sequence_table) throws BeanQLException {
        this.initialize(ds, sequence_table, null);
    }

    public BeanQLManager(DataSource ds, String sequence_table, Map custom_dao) throws BeanQLException {
        this.initialize(ds, sequence_table, custom_dao);
    }

    private void initialize(DataSource ds, String sequence_table, Map custom_dao) throws BeanQLException {
        this.parseVendar();
        this.ds = ds;
        this.sequenceTable = sequence_table;
        Log.println("[BeanQLManager#initialize() start --->");
        try {
            this.validateCustomDAO(custom_dao);
        }
        catch (ClassNotFoundException e) {
            throw new BeanQLException(e);
        }
        if (this.isExistTable(this.sequenceTable)) {
            return;
        }
        Log.println("[BeanQLManager#initialize() creating SequenceTable");
        this.createSequenceTable();
        Log.println("[BeanQLManager#initialize() end <---");
    }

    /*
     * Exception decompiling
     */
    private void parseVendar() throws BeanQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 203->207)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initialize(String driver_name, String url, String user, String password, String sequence_table, Map custom_dao) throws BeanQLException {
        this.driverName = driver_name;
        this.url = url;
        this.user = user;
        this.password = password;
        this.sequenceTable = sequence_table;
        this.customDAO = custom_dao;
        try {
            this.driver = (Driver)Class.forName(driver_name).newInstance();
            this.validateCustomDAO(custom_dao);
        }
        catch (InstantiationException e) {
            throw new BeanQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new BeanQLException(e);
        }
        catch (ClassNotFoundException e) {
            throw new BeanQLException(e);
        }
        this.parseVendar();
        if (this.isExistTable(this.sequenceTable)) {
            return;
        }
        this.createSequenceTable();
    }

    private void validateCustomDAO(Map custom_dao) throws ClassNotFoundException {
        if (custom_dao == null) {
            return;
        }
        Iterator it = custom_dao.keySet().iterator();
        while (it.hasNext()) {
            String bean = (String)it.next();
            String dao = (String)custom_dao.get(bean);
            Class.forName(bean);
            Class<?> dao_class = Class.forName(dao);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("jp.co.powerbeans.beanql.dao.BeanQLDAO");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (dao_class.isAssignableFrom(clazz)) continue;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("jp.co.powerbeans.beanql.dao.BeanQLDynaViewDAO");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (dao_class.isAssignableFrom(clazz2)) continue;
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = Class.forName("jp.co.powerbeans.beanql.dao.BeanQLViewDAO");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (dao_class.isAssignableFrom(clazz3)) continue;
            throw new IllegalArgumentException("CustomDAO:" + dao_class + " is not implement BeanQLDAO or BeanQLDynaViewDAO or BeanQLViewDAO");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSequenceTable() throws BeanQLException {
        BeanQLTransaction bt = this.getBeanQLTransaction();
        ColumnProperty[] cp = new ColumnProperty[2];
        cp[0] = new ColumnProperty();
        cp[0].setName("tableName");
        cp[0].setNullable(false);
        ColumnProperty columnProperty = cp[0];
        Class<?> clazz = class$3;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$3 = clazz2;
        }
        columnProperty.setType(clazz);
        cp[0].setDefaultValue("");
        cp[0].setPrimaryKey(true);
        cp[0].setSize(100);
        cp[1] = new ColumnProperty();
        cp[1].setName("sequence");
        cp[1].setNullable(false);
        ColumnProperty columnProperty2 = cp[1];
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz3 = class$4 = clazz4;
        }
        columnProperty2.setType(clazz3);
        cp[1].setDefaultValue(new Integer(1));
        cp[1].setPrimaryKey(false);
        try {
            try {
                DBDependQLStatement dqs = DBDependQLStatementFactory.create(bt.getConnection(), bt.mgr);
                Log.println("[BeanQLManager#createSequenceTable() creating SequenceTable");
                dqs.createTable(this.sequenceTable, cp);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BeanQLException("cannot create table:" + this.sequenceTable, e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            bt.close();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        bt.close();
        Log.println("[BeanQLManager#createSequenceTable() create SequenceTable ok");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isExistTable(String table_name) throws BeanQLException {
        boolean bl;
        BeanQLTransaction bt = this.getBeanQLTransaction();
        try {
            try {
                DBDependQLStatement dqs = DBDependQLStatementFactory.create(bt.getConnection(), bt.mgr);
                bl = dqs.isExistTable(table_name);
                Object var4_6 = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BeanQLException("cannot check exist table:" + table_name, e);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            bt.close();
            throw throwable;
        }
        bt.close();
        return bl;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public BeanQLTransaction getBeanQLTransaction() throws BeanQLException {
        if (this.ds != null) {
            try {
                Connection con = this.ds.getConnection();
                Log.println("connect. (DataSource): " + this.ds);
                return new BeanQLTransaction(con, this);
            }
            catch (SQLException e) {
                throw new BeanQLException(String.valueOf(e.getMessage()) + "\nDataSource connect error :" + this.ds);
            }
        }
        if (this.driver == null) {
            throw new BeanQLException("not loaded driver.");
        }
        Properties props = new Properties();
        props.put("user", this.user);
        props.put("password", this.password);
        try {
            Connection con = this.driver.connect(this.url, props);
            Log.println("connect. user:" + this.user + " password:XXXX url:" + this.url + " con:" + con);
            return new BeanQLTransaction(con, this);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BeanQLException(String.valueOf(e.getMessage()) + "\nJDBC connect error (check parameter:user " + this.user + ", url " + this.url, e);
        }
    }

    public BeanQLTransaction getBeanQLTransaction(Connection con) throws BeanQLException {
        return new BeanQLTransaction(con, this);
    }

    public int getVendorType() {
        return this.vendorType;
    }

    public String getSequenceTable() {
        return this.sequenceTable;
    }

    public BeanQLDAO createDAO(Class c) {
        if (this.customDAO != null && this.customDAO.containsKey(c.getName())) {
            try {
                return (BeanQLDAO)((Class)this.customDAO.get(c.getName())).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        BeanQLStandardDAO daoimpl = new BeanQLStandardDAO(this, c);
        return daoimpl;
    }

    public BeanQLDynaViewDAO createViewDAO(Class c, Class[] table_beans, String join_sql) {
        if (this.customDAO != null && this.customDAO.containsKey(c.getName())) {
            try {
                return (BeanQLDynaViewDAO)((Class)this.customDAO.get(c.getName())).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return new BeanQLStandardDynaViewDAO(this, c, table_beans, join_sql);
    }

    public BeanQLViewDAO createViewDAO(Class c) {
        if (this.customDAO != null && this.customDAO.containsKey(c.getName())) {
            try {
                return (BeanQLViewDAO)((Class)this.customDAO.get(c.getName())).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return new BeanQLStandardViewDAO(this, c);
    }

    public BeanQLExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(BeanQLExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }
}

