/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.beanql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import jp.co.powerbeans.beanql.BeanProperty;
import jp.co.powerbeans.beanql.BeanQLStatementIF;
import jp.co.powerbeans.beanql.BeanQLStatementSupport;
import jp.co.powerbeans.beanql.BeanQLTransaction;
import jp.co.powerbeans.beanql.BeanQLUtil;
import jp.co.powerbeans.beanql.BqlBlob;
import jp.co.powerbeans.beanql.Log;
import jp.co.powerbeans.beanql.TypeMappings;
import jp.co.powerbeans.beanql.exceptions.BeanQLException;
import jp.co.powerbeans.beanql.exceptions.BeanQLExclusiveException;
import jp.co.powerbeans.beanql.exceptions.BeanQLResultEmptyException;
import jp.co.powerbeans.beanql.exceptions.BeanQLResultMultiException;
import jp.co.powerbeans.beanql.exceptions.BeanQLTableNotFoundException;
import jp.co.powerbeans.beanql.vendor.DBDependQLStatement;
import jp.co.powerbeans.beanql.vendor.DBDependQLStatementFactory;

public class BeanQLPreparedStatement
extends BeanQLStatementSupport {
    private PreparedStatement preparedStatement;
    private String whereSql;

    BeanQLPreparedStatement(Class bean_class, PreparedStatement ps, BeanQLTransaction super_tr) throws BeanQLException, BeanQLTableNotFoundException {
        this(bean_class, ps, null, super_tr);
    }

    BeanQLPreparedStatement(Class bean_class, PreparedStatement ps, String where_sql, BeanQLTransaction super_tr) throws BeanQLException, BeanQLTableNotFoundException {
        this.bean = bean_class;
        this.preparedStatement = ps;
        this.super_tr = super_tr;
        this.whereSql = where_sql;
        this.tableName = BeanQLUtil.className2TableName(this.bean);
        try {
            this.createSQLMapping();
        }
        catch (SQLException e) {
            throw new BeanQLException("fail to create bean mapping [" + this.bean.getName() + "] (" + e.getMessage() + ")", e);
        }
    }

    public Collection select() throws SQLException, BeanQLException {
        ArrayList<Object> result_list = new ArrayList<Object>();
        ResultSet result = this.preparedStatement.executeQuery();
        while (result.next()) {
            result_list.add(this.getBeanByResultSet(result));
        }
        result.close();
        return result_list;
    }

    public Object selectOne() throws SQLException, BeanQLException, BeanQLResultEmptyException, BeanQLResultMultiException {
        Collection col = this.select();
        if (col.isEmpty()) {
            throw new BeanQLResultEmptyException("\u691c\u7d22\u7d50\u679c 0\u4ef6");
        }
        if (col.size() > 1) {
            throw new BeanQLResultMultiException("\u691c\u7d22\u7d50\u679c " + col.size() + "\u4ef6");
        }
        Object o = null;
        Iterator it = col.iterator();
        while (it.hasNext()) {
            o = it.next();
        }
        return o;
    }

    public void close() throws BeanQLException {
        if (this.preparedStatement != null) {
            try {
                this.preparedStatement.close();
            }
            catch (SQLException e) {
                throw new BeanQLException(e);
            }
        }
    }

    public static void closeSafe(BeanQLStatementIF st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (BeanQLException e) {
            e.printStackTrace();
        }
    }

    public void setArray(int i, Array x) throws SQLException {
        this.preparedStatement.setArray(i, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.preparedStatement.setAsciiStream(parameterIndex, x, length);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.preparedStatement.setBigDecimal(parameterIndex, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.preparedStatement.setBinaryStream(parameterIndex, x, length);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.preparedStatement.setBlob(i, x);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.preparedStatement.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.preparedStatement.setByte(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.preparedStatement.setBytes(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.preparedStatement.setCharacterStream(parameterIndex, reader, length);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.preparedStatement.setClob(i, x);
    }

    public void setCursorName(String arg0) throws SQLException {
        this.preparedStatement.setCursorName(arg0);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.preparedStatement.setDate(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.preparedStatement.setDate(parameterIndex, x, cal);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.preparedStatement.setDouble(parameterIndex, x);
    }

    public void setEscapeProcessing(boolean arg0) throws SQLException {
        this.preparedStatement.setEscapeProcessing(arg0);
    }

    public void setFetchDirection(int arg0) throws SQLException {
        this.preparedStatement.setFetchDirection(arg0);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.preparedStatement.setFloat(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.preparedStatement.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.preparedStatement.setLong(parameterIndex, x);
    }

    public void setMaxFieldSize(int arg0) throws SQLException {
        this.preparedStatement.setMaxFieldSize(arg0);
    }

    public void setMaxRows(int arg0) throws SQLException {
        this.preparedStatement.setMaxRows(arg0);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.preparedStatement.setNull(parameterIndex, sqlType);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.preparedStatement.setNull(paramIndex, sqlType, typeName);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setQueryTimeout(int arg0) throws SQLException {
        this.preparedStatement.setQueryTimeout(arg0);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.preparedStatement.setRef(i, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.preparedStatement.setShort(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.preparedStatement.setString(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.preparedStatement.setTime(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.preparedStatement.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.preparedStatement.setTimestamp(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.preparedStatement.setTimestamp(parameterIndex, x, cal);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.preparedStatement.setUnicodeStream(parameterIndex, x, length);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.preparedStatement.setURL(parameterIndex, x);
    }

    public int update() throws BeanQLException, SQLException {
        return this.preparedStatement.executeUpdate();
    }

    public int insert(Object o) throws BeanQLException, SQLException {
        this.validateBean(o);
        DBDependQLStatement dep = DBDependQLStatementFactory.create(this.super_tr.getConnection(), this.super_tr.mgr);
        int c = 1;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Iterator bpit = this.bpList.iterator();
        while (bpit.hasNext()) {
            BeanProperty bp = (BeanProperty)bpit.next();
            if (bp.getColumnProp().isNotUseInsertSql()) continue;
            Object val = this.getValueByType(o, bp);
            this.setPreparedValue(c++, bp, val, dep, timestamp);
        }
        return this.preparedStatement.executeUpdate();
    }

    private void setPreparedValue(int i, BeanProperty bp, Object val, DBDependQLStatement dep, Timestamp timestamp) throws SQLException, BeanQLException {
        String type_as_db = bp.columnProp.getTypeAsDB().toUpperCase();
        if (val != null && val instanceof BqlBlob) {
            BqlBlob bl = (BqlBlob)val;
            InputStream is = bl.getBinaryStream();
            this.preparedStatement.setBinaryStream(i, is, (int)bl.length());
            Log.debug("preparedStatement setBinaryStream(" + i + "," + val + ") DB:" + bp.columnProp.getName() + "," + type_as_db + " JAVA:" + bp.getType());
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new BeanQLException(e);
            }
            return;
        }
        if (!TypeMappings.java2ResultsetSetter.containsKey(bp.getType().getName())) {
            throw new BeanQLException("setPreparedValue unsupport type:" + bp.getType().getName());
        }
        Method m_set = (Method)TypeMappings.java2ResultsetSetter.get(bp.getType().getName());
        if (type_as_db.equals("TIMESTAMP") && val == null) {
            this.preparedStatement.setTimestamp(i, timestamp);
            Log.debug("preparedStatement " + m_set.getName() + "(" + i + "," + val + ") DB:" + bp.columnProp.getName() + "," + type_as_db + " JAVA:" + bp.getType());
            return;
        }
        try {
            if (val instanceof java.util.Date) {
                if (type_as_db.equals("DATE")) {
                    val = new Date(((java.util.Date)val).getTime());
                    m_set = (Method)TypeMappings.java2ResultsetSetter.get("java.sql.Date");
                } else if (type_as_db.equals("TIME") || type_as_db.equals("TIMETZ")) {
                    val = new Time(((java.util.Date)val).getTime());
                    m_set = (Method)TypeMappings.java2ResultsetSetter.get("java.sql.Time");
                } else if (type_as_db.startsWith("TIMESTAMP") || type_as_db.equals("DATETIME")) {
                    val = new Timestamp(((java.util.Date)val).getTime());
                    m_set = (Method)TypeMappings.java2ResultsetSetter.get("java.sql.Timestamp");
                }
            }
            m_set.invoke((Object)this.preparedStatement, BeanQLUtil.getInteger(i), val);
            Log.debug("preparedStatement " + m_set.getName() + "(" + i + "," + val + ") DB:" + bp.columnProp.getName() + "," + type_as_db + " JAVA:" + bp.getType());
        }
        catch (Exception e) {
            throw new BeanQLException(e);
        }
    }

    public int updateExclusive(Object o, String exclusive_check_field) throws SQLException, BeanQLException, BeanQLResultEmptyException, BeanQLResultMultiException, BeanQLExclusiveException {
        Object val;
        BeanProperty bp;
        this.validateBean(o);
        DBDependQLStatement dep = DBDependQLStatementFactory.create(this.super_tr.getConnection(), this.super_tr.mgr);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        if (exclusive_check_field != null && exclusive_check_field.length() > 0 && this.whereSql != null && this.whereSql.trim().length() > 0) {
            BeanQLPreparedStatement lockps = this.super_tr.createPreparedStatement(this.bean, "SELECT * FROM " + this.getTableName() + " WHERE " + this.whereSql + " FOR UPDATE ");
            int c = 1;
            Iterator bpit = this.bpList.iterator();
            while (bpit.hasNext()) {
                BeanProperty bp2 = (BeanProperty)bpit.next();
                if (!bp2.columnProp.isPrimaryKey()) continue;
                Object val2 = this.getValueByType(o, bp2);
                lockps.setPreparedValue(c++, bp2, val2, dep, timestamp);
            }
            Object db_bean = lockps.selectOne();
            if (!this.equalFieldVal(db_bean, o, exclusive_check_field)) {
                throw new BeanQLExclusiveException(String.valueOf(this.getTableName()) + "." + exclusive_check_field + " is not match in bean.");
            }
        }
        int c = 1;
        Iterator bpit = this.bpList.iterator();
        while (bpit.hasNext()) {
            bp = (BeanProperty)bpit.next();
            if (bp.getColumnProp().isNotUseInsertSql()) continue;
            val = null;
            String type_as_db = bp.getColumnProp().getTypeAsDB();
            val = bp.getColumnProp().getName().equalsIgnoreCase(exclusive_check_field) && (type_as_db.equalsIgnoreCase("TIMESTAMP") || type_as_db.equalsIgnoreCase("DATETIME") || type_as_db.equalsIgnoreCase("DATE")) ? timestamp : this.getValueByType(o, bp);
            this.setPreparedValue(c++, bp, val, dep, timestamp);
        }
        bpit = this.bpList.iterator();
        while (bpit.hasNext()) {
            bp = (BeanProperty)bpit.next();
            if (!bp.columnProp.isPrimaryKey()) continue;
            val = this.getValueByType(o, bp);
            this.setPreparedValue(c++, bp, val, dep, timestamp);
        }
        return this.preparedStatement.executeUpdate();
    }
}

